/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import java.util.ArrayList;
import java.util.List;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.MethodInvokingJobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import sinosoftgz.config.QuartzConfigVo;

@Configuration
@ConditionalOnProperty(name={"quartz.enabled"})
@ConfigurationProperties(prefix="jobs")
@Lazy(value=false)
public class QuartzConfig
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private int jobconfigIndex = 0;
    List<QuartzConfigVo> joblist = new ArrayList<QuartzConfigVo>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public SchedulerFactoryBean jobFactory() {
        SchedulerFactoryBean factoryBean = new SchedulerFactoryBean();
        ArrayList<CronTrigger> triggerList = new ArrayList<CronTrigger>();
        int i = 0;
        while (i < this.joblist.size()) {
            this.jobconfigIndex = i++;
            triggerList.add(this.triggerFactoryBeans().getObject());
        }
        Trigger[] triggers = new Trigger[triggerList.size()];
        factoryBean.setTriggers(triggerList.toArray(triggers));
        return factoryBean;
    }

    public List<QuartzConfigVo> getJoblist() {
        return this.joblist;
    }

    public void setJoblist(List<QuartzConfigVo> joblist) {
        this.joblist = joblist;
    }

    public void afterPropertiesSet() throws Exception {
        ArrayList<QuartzConfigVo> new_jobList = new ArrayList<QuartzConfigVo>();
        for (QuartzConfigVo job : this.joblist) {
            if (!job.getRunFlag().booleanValue()) continue;
            new_jobList.add(job);
        }
        this.joblist = new_jobList;
    }

    @Bean
    @Scope(value="prototype")
    public CronTriggerFactoryBean triggerFactoryBeans() {
        QuartzConfigVo quartzConfigVo = this.joblist.get(this.jobconfigIndex);
        CronTriggerFactoryBean trigger = new CronTriggerFactoryBean();
        trigger.setName(quartzConfigVo.getJobName());
        trigger.setBeanName("trigger_" + quartzConfigVo.getJobName());
        MethodInvokingJobDetailFactoryBean bean = this.jobDetailFactoryBean();
        trigger.setJobDetail(bean.getObject());
        trigger.getJobDataMap().put(QuartzConfigVo.class.getName(), (Object)quartzConfigVo);
        trigger.setCronExpression(quartzConfigVo.getTriggerCronExpression());
        return trigger;
    }

    @Bean(name={"jobDetailFactoryBean"})
    @Scope(value="prototype")
    MethodInvokingJobDetailFactoryBean jobDetailFactoryBean() {
        QuartzConfigVo quartzConfigVo = this.joblist.get(this.jobconfigIndex);
        MethodInvokingJobDetailFactoryBean detail = new MethodInvokingJobDetailFactoryBean();
        detail.setConcurrent(quartzConfigVo.getConcurrent().booleanValue());
        detail.setBeanName("detail_" + quartzConfigVo.getJobName());
        detail.setName("detail_" + quartzConfigVo.getJobName());
        detail.setTargetBeanName("detail_target_" + quartzConfigVo.getJobName());
        try {
            detail.setTargetObject(this.applicationContext.getBean(Class.forName(quartzConfigVo.getJobClass())));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        detail.setTargetMethod(quartzConfigVo.getJobClassRunMethod());
        return detail;
    }
}

