/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.spring.AnnotationBean;
import com.alibaba.dubbo.rpc.Exporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sinosoftgz.config.dubboproperties.DubboApplication;
import sinosoftgz.config.dubboproperties.DubboProtocol;
import sinosoftgz.config.dubboproperties.DubboProvider;
import sinosoftgz.config.dubboproperties.DubboRegistry;

@Configuration
@ConditionalOnClass(value={Exporter.class})
@EnableConfigurationProperties(value={DubboApplication.class, DubboProtocol.class, DubboRegistry.class, DubboProvider.class})
public class DubboConfig {
    @Autowired
    private DubboApplication dubboApplication;
    @Autowired
    private DubboProtocol dubboProtocol;
    @Autowired
    private DubboProvider dubboProvider;
    @Autowired
    private DubboRegistry dubboRegistry;
    static final Logger logger = LoggerFactory.getLogger(DubboConfig.class);

    @Bean
    public static AnnotationBean annotationBean(@Value(value="${dubbo.annotation.package}") String packageName) {
        AnnotationBean annotationBean = new AnnotationBean();
        annotationBean.setPackage(packageName);
        logger.info("[DubboAutoConfiguration] {}", (Object)packageName);
        return annotationBean;
    }

    @Bean
    public ApplicationConfig applicationConfig() {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setName(this.dubboApplication.getName());
        applicationConfig.setLogger(this.dubboApplication.getLogger());
        logger.info("[DubboAutoConfiguration] {}", (Object)this.dubboApplication);
        return applicationConfig;
    }

    @Bean
    public ProtocolConfig protocolConfig() {
        ProtocolConfig protocolConfig = new ProtocolConfig();
        protocolConfig.setName(this.dubboProtocol.getName());
        protocolConfig.setPort(Integer.valueOf(this.dubboProtocol.getPort()));
        protocolConfig.setAccesslog(String.valueOf(this.dubboProtocol.isAccessLog()));
        logger.info("[DubboAutoConfiguration] {}", (Object)this.dubboProtocol);
        return protocolConfig;
    }

    @Bean
    public ProviderConfig providerConfig(ApplicationConfig applicationConfig, RegistryConfig registryConfig, ProtocolConfig protocolConfig) {
        ProviderConfig providerConfig = new ProviderConfig();
        providerConfig.setTimeout(Integer.valueOf(this.dubboProvider.getTimeout()));
        providerConfig.setRetries(Integer.valueOf(this.dubboProvider.getRetries()));
        providerConfig.setDelay(Integer.valueOf(this.dubboProvider.getDelay()));
        providerConfig.setApplication(applicationConfig);
        providerConfig.setRegistry(registryConfig);
        providerConfig.setProtocol(protocolConfig);
        logger.info("[DubboAutoConfiguration] {}", (Object)this.dubboProvider);
        return providerConfig;
    }

    @Bean
    public RegistryConfig registryConfig() {
        RegistryConfig registryConfig = new RegistryConfig();
        registryConfig.setProtocol(this.dubboRegistry.getProtocol());
        registryConfig.setAddress(this.dubboRegistry.getAddress());
        registryConfig.setRegister(Boolean.valueOf(this.dubboRegistry.isRegister()));
        registryConfig.setSubscribe(Boolean.valueOf(this.dubboRegistry.isSubscribe()));
        logger.info("[DubboAutoConfiguration] {}", (Object)this.dubboRegistry);
        return registryConfig;
    }
}

