/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import com.weibo.api.motan.config.springsupport.AnnotationBean;
import com.weibo.api.motan.config.springsupport.BasicRefererConfigBean;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.ProtocolConfigBean;
import com.weibo.api.motan.config.springsupport.RegistryConfigBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.spring.ApplicationContextProvider;

@Configuration
public class MotanConfig {
    @Bean
    ApplicationContextProvider applicationContextProvider() {
        return new ApplicationContextProvider();
    }

    @Bean
    public AnnotationBean motanAnnotationBean(@Value(value="${motan.annotaiong-package}") String annotaiongPackage) {
        AnnotationBean motanAnnotationBean = new AnnotationBean();
        motanAnnotationBean.setPackage(annotaiongPackage);
        if (motanAnnotationBean.getPackage() == null) {
            throw new RuntimeException("\u8bf7\u914d\u7f6ematon api \u5305");
        }
        return motanAnnotationBean;
    }

    @Bean(name={"motanServer"})
    public ProtocolConfigBean protocolConfig() {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setSerialization("hibernateHessian2");
        config.setName("motan");
        config.setMaxContentLength(Integer.valueOf(0x100000));
        return config;
    }

    @Bean(name={"motanClient"})
    public ProtocolConfigBean protocolConfigClient() {
        ProtocolConfigBean config = new ProtocolConfigBean();
        config.setDefault(true);
        config.setSerialization("hibernateHessian2");
        config.setName("motan");
        config.setMaxContentLength(Integer.valueOf(0x100000));
        return config;
    }

    @Bean(name={"registry"})
    public RegistryConfigBean registryConfigSit(@Value(value="${motan.zookeeper-host}") String zookeeperHost) {
        RegistryConfigBean config = new RegistryConfigBean();
        config.setDefault(true);
        config.setRegProtocol("zookeeper");
        config.setAddress(zookeeperHost);
        return config;
    }

    @Bean(name={"motanServerBasicConfig"})
    public BasicServiceConfigBean baseServiceConfig(@Value(value="${motan.export-port}") Integer exportPort, @Value(value="${motan.server-group}") String serverGroup, @Value(value="${motan.server-access-log}") Boolean serverAccessLog) {
        BasicServiceConfigBean config = new BasicServiceConfigBean();
        config.setDefault(true);
        config.setExport("motanServer:" + exportPort);
        if (Lang.isEmpty((Object)serverGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(serverGroup);
        }
        if (Lang.isEmpty((Object)serverAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(serverAccessLog.booleanValue());
        }
        config.setShareChannel(Boolean.valueOf(true));
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setFilter("openjpasession");
        config.setRegistry("registry");
        return config;
    }

    @Bean(name={"motanClientBasicConfig"})
    public BasicRefererConfigBean baseRefererConfig(@Value(value="${motan.client-group}") String clientGroup, @Value(value="${motan.client-access-log}") Boolean clientAccessLog) {
        BasicRefererConfigBean config = new BasicRefererConfigBean();
        config.setProtocol("motanClient");
        if (Lang.isEmpty((Object)clientGroup)) {
            config.setGroup("sinomall");
        } else {
            config.setGroup(clientGroup);
        }
        if (Lang.isEmpty((Object)clientAccessLog)) {
            config.setAccessLog(true);
        } else {
            config.setAccessLog(clientAccessLog.booleanValue());
        }
        config.setRegistry("registry");
        config.setCheck(false);
        config.setRetries(Integer.valueOf(2));
        config.setRequestTimeout(Integer.valueOf(60000));
        config.setThrowException(Boolean.valueOf(true));
        config.setDefault(true);
        return config;
    }
}

