/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"druid.enable"})
public class DruidConfig {
    private static final Logger logger = LoggerFactory.getLogger(DruidConfig.class);
    @Autowired
    DataSourceProperties dataSourceProperties;

    @Bean
    public DataSource druidDataSource(@Value(value="${druid.remoteconfig.url}") Properties properties, @Value(value="${druid.filters}") String druidFilter, @Value(value="${druid.validationQuery}") String validationQuery, @Value(value="${druid.remoteconfig.enable}") boolean remoteconfig) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setDriverClassName(this.dataSourceProperties.getDriverClassName());
        druidDataSource.setUrl(this.dataSourceProperties.getUrl());
        druidDataSource.setUsername(this.dataSourceProperties.getUsername());
        if (!Strings.isNullOrEmpty((String)this.dataSourceProperties.getPassword())) {
            druidDataSource.setPassword(this.dataSourceProperties.getPassword());
        }
        if (StringUtils.isNotEmpty((String)validationQuery)) {
            druidDataSource.setTestOnBorrow(true);
            druidDataSource.setValidationQuery(validationQuery);
        }
        try {
            if (StringUtils.isNotEmpty((String)druidFilter)) {
                druidDataSource.setFilters(druidFilter);
            } else {
                druidDataSource.setFilters("stat, wall");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (remoteconfig) {
            try {
                druidDataSource.addFilters("config");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (properties != null && properties.size() > 0) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    try {
                        druidDataSource.addConnectionProperty(entry.getKey().toString(), entry.getValue().toString());
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return druidDataSource;
    }

    @Bean
    @ConditionalOnProperty(value={"druid.servlet.enable"})
    public ServletRegistrationBean druidServlet() {
        return new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
    }

    @Bean
    @ConditionalOnProperty(value={"druid.servlet.enable"})
    public FilterRegistrationBean filterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new WebStatFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", "*.js,*.gif,*.jpg,*.png,*.css,*.ico,/druid/*");
        return filterRegistrationBean;
    }
}

