/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import freemarker.template.TemplateModel;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;
import sinosoftgz.utils.freemarker.EncodeURLMethod;

@Configuration
public class FreeMarkerConfig
implements InitializingBean,
ServletContextAware {
    @Autowired
    FreeMarkerConfigurer freeMarkerConfigurer;
    @Value(value="${context.commonstatic}")
    private String commonStaticPath;
    @Value(value="${context.projectstatic}")
    private String projectStaticPath;
    @Value(value="${context.ctx}")
    private String dynaContentPath;
    @Autowired
    ResourceUrlProvider resourceUrlProvider;
    ServletContext servletContext;

    @Bean
    public EncodeURLMethod encodeURLMethod() {
        return new EncodeURLMethod(this.resourceUrlProvider);
    }

    public void afterPropertiesSet() throws Exception {
        freemarker.template.Configuration configuration = this.freeMarkerConfigurer.getConfiguration();
        String projectContextPath = this.servletContext.getContextPath();
        configuration.setSharedVariable("c_static", (Object)this.commonStaticPath);
        if (StringUtils.isEmpty((Object)this.commonStaticPath)) {
            configuration.setSharedVariable("c_static", (Object)projectContextPath);
        }
        configuration.setSharedVariable("p_static", (Object)this.projectStaticPath);
        if (StringUtils.isEmpty((Object)this.projectStaticPath)) {
            configuration.setSharedVariable("p_static", (Object)projectContextPath);
        }
        configuration.setSharedVariable("ctx", (Object)this.dynaContentPath);
        if (StringUtils.isEmpty((Object)this.dynaContentPath)) {
            configuration.setSharedVariable("ctx", (Object)projectContextPath);
        }
        this.freeMarkerConfigurer.getConfiguration().setSharedVariable("_v", (TemplateModel)this.encodeURLMethod());
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

