/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.config;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.springframework.web.servlet.resource.VersionStrategy;
import sinosoftgz.utils.interceptor.BusinessWebInterceptor;
import sinosoftgz.utils.springmvc.ContentParaVersionStrategy;
import sinosoftgz.utils.springmvc.converter.fastjson.HibernateFastJsonConverter;

@Configuration
public class SpringMvcConfig {

    @Configuration
    @AutoConfigureOrder
    protected static class MvcConfigurerAdapter
    extends WebMvcConfigurerAdapter {
        @Autowired(required=false)
        List<BusinessWebInterceptor> comstomerIntercepters;

        protected MvcConfigurerAdapter() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            if (this.comstomerIntercepters != null) {
                for (WebRequestInterceptor webRequestInterceptor : this.comstomerIntercepters) {
                    registry.addWebRequestInterceptor(webRequestInterceptor);
                }
            }
        }

        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            super.configureMessageConverters(converters);
            Charset defCharset = Charset.forName("UTF-8");
            HibernateFastJsonConverter fastConverter = new HibernateFastJsonConverter();
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(new MediaType("text", "json", defCharset));
            mediaTypes.add(new MediaType("application", "json", defCharset));
            fastConverter.setSupportedMediaTypes(mediaTypes);
            converters.add((HttpMessageConverter<?>)fastConverter);
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"}).setCachePeriod(Integer.valueOf(1471228928)).resourceChain(true).addResolver((ResourceResolver)new VersionResourceResolver().addVersionStrategy((VersionStrategy)new ContentParaVersionStrategy(), new String[]{"/**"}));
        }
    }
}

