/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter.sleuth;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.filter.sleuth.SleuthTracingContext;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.trace.DefaultTracer;

@SpiMeta(name="sleuth-tracing")
@Activation(sequence=30)
public class SleuthTracingFilter
implements Filter {
    public static final String MOTAN_TAG = "motan";
    SpanInjector spanInjector;
    HttpTraceKeysInjector httpTraceKeysInjector;

    public Response filter(Caller<?> caller, Request request) {
        Tracer tracer = this.getTracer();
        if (tracer == null || !(tracer instanceof DefaultTracer)) {
            return caller.call(request);
        }
        if (caller instanceof Provider) {
            return this.processProviderTrace(tracer, caller, request);
        }
        return this.processRefererTrace(tracer, caller, request);
    }

    protected Tracer getTracer() {
        return SleuthTracingContext.getTracer();
    }

    protected Response processRefererTrace(Tracer tracer, Caller<?> caller, Request request) {
        Span span = this.extractTraceInfo(request, tracer);
        span.logEvent("cs");
        if (span.getSavedSpan() != null && span.getSavedSpan().tags() != null) {
            for (Map.Entry stringStringEntry : span.getSavedSpan().tags().entrySet()) {
                this.setHeader(request, (String)stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        span.tag("requestId", String.valueOf(request.getRequestId()));
        span.tag("lc", MOTAN_TAG);
        this.attachTraceInfo(tracer, span, request);
        return this.process(tracer, caller, request, span);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response process(Tracer tracer, Caller<?> caller, Request request, Span span) {
        Response response2;
        Exception ex = null;
        boolean exception = true;
        try {
            Response response = caller.call(request);
            if (response.getException() != null) {
                ex = response.getException();
            } else {
                exception = false;
            }
            response2 = response;
        }
        catch (RuntimeException e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    if (exception) {
                        span.logEvent("motan request fail." + (ex == null ? "unknown exception" : ex.getMessage()));
                    } else if (caller instanceof Provider) {
                        span.logEvent("ss");
                    } else {
                        span.logEvent("cr");
                    }
                    tracer.close(span);
                    throw throwable;
                }
                catch (Exception e2) {
                    LoggerUtil.error((String)"opentracing span finish error!", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            if (exception) {
                span.logEvent("motan request fail." + (ex == null ? "unknown exception" : ex.getMessage()));
            } else if (caller instanceof Provider) {
                span.logEvent("ss");
            } else {
                span.logEvent("cr");
            }
            tracer.close(span);
            return response2;
        }
        catch (Exception e) {
            LoggerUtil.error((String)"opentracing span finish error!", (Throwable)e);
        }
        return response2;
    }

    protected String buildOperationName(Request request) {
        return "Motan_" + MotanFrameworkUtil.getGroupMethodString((Request)request);
    }

    private void setHeader(Request request, String key, Object value) {
        if (value != null) {
            request.setAttachment(key, value.toString());
        }
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? (Long)span.getParents().get(0) : null;
    }

    protected void attachTraceInfo(Tracer tracer, Span span, Request request) {
        if (span == null) {
            this.setHeader(request, "X-B3-Sampled", "0");
            return;
        }
        this.setHeader(request, TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR, "true");
        this.setHeader(request, "X-B3-SpanId", Span.idToHex((long)span.getSpanId()));
        this.setHeader(request, "X-B3-TraceId", span.traceIdString());
        this.setHeader(request, "X-Span-Name", span.getName());
        this.setHeader(request, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(request, "X-B3-ParentSpanId", Span.idToHex((long)this.getParentId(span)));
        this.setHeader(request, "X-Process-Id", span.getProcessId());
        if (span.getSavedSpan() != null && span.getSavedSpan().tags() != null) {
            for (Map.Entry stringStringEntry : span.getSavedSpan().tags().entrySet()) {
                this.setHeader(request, (String)stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
    }

    protected Response processProviderTrace(Tracer tracer, Caller<?> caller, Request request) {
        Span span = this.extractTraceInfo(request, tracer);
        span.tag("requestId", String.valueOf(request.getRequestId()));
        span.logEvent("sr");
        SleuthTracingContext.setActiveSpan(span);
        return this.process(tracer, caller, request, span);
    }

    protected Span extractTraceInfo(Request request, Tracer tracer) {
        Span parentSpan = tracer.getCurrentSpan();
        if (parentSpan == null) {
            Span.SpanBuilder spanBuilder = Span.builder();
            if (request.getAttachments().get("spanTraceId") != null && !"".equals(request.getAttachments().get("spanTraceId"))) {
                spanBuilder.traceId(Span.hexToId((String)((String)request.getAttachments().get("spanTraceId"))));
                spanBuilder.spanId(Span.hexToId((String)((String)request.getAttachments().get("spanId"))));
                spanBuilder.exportable("1".equals(request.getAttachments().get("spanSampled")));
                spanBuilder.processId((String)request.getAttachments().get("spanProcessId"));
                spanBuilder.parent(Long.valueOf(Span.hexToId((String)((String)request.getAttachments().get("spanParentSpanId")))));
                spanBuilder.name((String)request.getAttachments().get("spanName"));
                spanBuilder.remote(true);
                parentSpan = spanBuilder.build();
            } else if (request.getAttachments().get("X-B3-TraceId") != null && !"".equals(request.getAttachments().get("X-B3-TraceId"))) {
                spanBuilder.traceId(Span.hexToId((String)((String)request.getAttachments().get("X-B3-TraceId"))));
                spanBuilder.spanId(Span.hexToId((String)((String)request.getAttachments().get("X-B3-SpanId"))));
                spanBuilder.exportable("1".equals(request.getAttachments().get("X-B3-Sampled")));
                spanBuilder.processId((String)request.getAttachments().get("X-Process-Id"));
                if (request.getAttachments().get("X-B3-ParentSpanId") != null) {
                    spanBuilder.parent(Long.valueOf(Span.hexToId((String)((String)request.getAttachments().get("X-B3-ParentSpanId")))));
                }
                spanBuilder.name((String)request.getAttachments().get("X-Span-Name"));
                spanBuilder.remote(true);
                parentSpan = spanBuilder.build();
            }
        }
        String operationName = this.buildOperationName(request);
        Span newSpan = tracer.createSpan("motan:" + request.getMethodName(), parentSpan);
        newSpan.tag("motan_method", operationName);
        newSpan.tag("requestId", String.valueOf(request.getRequestId()));
        newSpan.tag("lc", MOTAN_TAG);
        return newSpan;
    }
}

