/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.concurrent;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisLock {
    private static Logger logger = LoggerFactory.getLogger(RedisLock.class);
    private RedisTemplate redisTemplate;
    private static final int DEFAULT_ACQUIRY_RESOLUTION_MILLIS = 100;
    private String lockKey;
    private int expireMsecs = 60000;
    private int timeoutMsecs = 10000;
    private volatile boolean locked = false;

    public RedisLock(RedisTemplate redisTemplate, String lockKey) {
        this.redisTemplate = redisTemplate;
        this.lockKey = lockKey + "_lock";
    }

    public RedisLock(RedisTemplate redisTemplate, String lockKey, int timeoutMsecs) {
        this(redisTemplate, lockKey);
        this.timeoutMsecs = timeoutMsecs;
    }

    public RedisLock(RedisTemplate redisTemplate, String lockKey, int timeoutMsecs, int expireMsecs) {
        this(redisTemplate, lockKey, timeoutMsecs);
        this.expireMsecs = expireMsecs;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    private String get(String key) {
        Object obj = null;
        try {
            obj = this.redisTemplate.boundValueOps((Object)key).get();
        }
        catch (Exception e) {
            logger.error("get redis error, key : {}", (Object)key);
        }
        return obj != null ? obj.toString() : null;
    }

    private boolean setNX(String key, String value) {
        Boolean obj = null;
        try {
            obj = this.redisTemplate.boundValueOps((Object)key).setIfAbsent((Object)value);
        }
        catch (Exception e) {
            logger.error("setIfAbsent error, key : {}", (Object)key);
        }
        return obj != null ? obj : false;
    }

    private String getSet(String key, String value) {
        Object obj = null;
        try {
            obj = this.redisTemplate.boundValueOps((Object)key).getAndSet((Object)value);
        }
        catch (Exception e) {
            logger.error("getAndSet error, key : {}", (Object)key);
        }
        return obj != null ? (String)obj : null;
    }

    public synchronized boolean lock() throws InterruptedException {
        for (int timeout = this.timeoutMsecs; timeout >= 0; timeout -= 100) {
            String oldValueStr;
            long expires = System.currentTimeMillis() + (long)this.expireMsecs + 1L;
            String expiresStr = String.valueOf(expires);
            if (this.setNX(this.lockKey, expiresStr)) {
                this.locked = true;
                return true;
            }
            String currentValueStr = this.get(this.lockKey);
            if (currentValueStr != null && Long.parseLong(currentValueStr) < System.currentTimeMillis() && (oldValueStr = this.getSet(this.lockKey, expiresStr)) != null && oldValueStr.equals(currentValueStr)) {
                this.locked = true;
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    public synchronized void unlock() {
        if (this.locked) {
            this.redisTemplate.delete((Object)this.lockKey);
            this.locked = false;
        }
    }
}

