/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"sms");
    private static String CODE = "code";
    private static String TIMESTAMP = "timestamp";

    public static String smsCode() {
        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; ++i) {
            result = result + random.nextInt(10);
        }
        return result;
    }

    public static String smsContent(String code) {
        String content = "\u4eb2\u7231\u7684\u7528\u6237\u60a8\u597d\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u662f:" + code + "\uff0c\u6709\u6548\u671f\u4e3a30\u5206\u949f\u3002";
        return content;
    }

    public static JSONObject smsCodeJson(String code) {
        if (code == null) {
            code = SmsUtil.smsCode();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CODE, (Object)code);
        jsonObject.put(TIMESTAMP, (Object)System.currentTimeMillis());
        return jsonObject;
    }

    public static int checkPhoneCode(String currentCode, Object object) {
        if (currentCode == null) {
            return -1;
        }
        if (object == null) {
            return -2;
        }
        JSONObject jsonObject = (JSONObject)object;
        long timeStamp = jsonObject.getLong(TIMESTAMP);
        long currenTimeStamp = System.currentTimeMillis();
        if (currenTimeStamp - timeStamp > 1800000L) {
            return 2;
        }
        String code = jsonObject.getString(CODE);
        if (code != null && code.equals(currentCode)) {
            return 0;
        }
        return 1;
    }
}

