/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.io.UnsafeByteArrayInputStream;
import sinosoftgz.utils.io.UnsafeStringReader;

public class Xmls {
    public static void handle(XpathHandler xmlHandler, Reader reader) {
        try {
            InputSource source = new InputSource(reader);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(source);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xmlHandler.handle(document, xpath);
        }
        catch (Throwable e) {
            throw Lang.unchecked(e);
        }
    }

    public static void handle(XpathHandler xmlHandler, String xml) {
        Xmls.handle(xmlHandler, new UnsafeStringReader(xml));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(XpathHandler xmlHandler, InputStream is, String charset) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, charset);){
            Xmls.handle(xmlHandler, reader);
        }
    }

    public static void handle(XpathHandler xmlHandler, File file, String charset) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Xmls.handle(xmlHandler, inputStream, charset);
        }
    }

    public static void handle(XpathHandler xmlHandler, byte[] bytes, String charset) {
        UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(bytes);
        try {
            Xmls.handle(xmlHandler, inputStream, charset);
        }
        catch (IOException e) {
            throw Lang.unchecked(e);
        }
    }

    public static interface XpathHandler {
        public void handle(Document var1, XPath var2) throws Throwable;
    }
}

