/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.filter;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.annotation.Order;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483597)
public class FrontEndLoginCheckFilter
extends OncePerRequestFilter {
    private String loginUrl;
    private String defaultSuccessUrl;
    private String[] checkUrls = new String[0];
    private String[] excludeUrls = new String[0];
    PathMatcher matcher = new AntPathMatcher();
    ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal();
    @Autowired
    ServerProperties serverProperties;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object sessionUserId;
        String requestUrl = request.getRequestURI();
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUrl)) continue;
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean checkFlag = false;
        for (String checkUrl : this.checkUrls) {
            if (!this.matcher.match(checkUrl, requestUrl)) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag && ((sessionUserId = request.getSession().getAttribute("user_id")) == null || StringUtils.isBlank((CharSequence)sessionUserId.toString()))) {
            String tk = request.getParameter("tk");
            String pgp = request.getParameter("pgp");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tk}) && StringUtils.isNotBlank((CharSequence)pgp)) {
                tk = tk.trim();
                pgp = pgp.trim();
                Date today = new Date();
                Date yesterday = new Date(today.getTime() - 86400000L);
                SimpleDateFormat sdf = this.formatter.get();
                if (sdf == null) {
                    sdf = new SimpleDateFormat("MM-dd:yyyy");
                    this.formatter.set(sdf);
                }
                String ctoday = sdf.format(today);
                String cyesterday = sdf.format(yesterday);
                if (StringUtils.equals((CharSequence)pgp, (CharSequence)DigestUtils.md5Hex((String)(tk + ctoday))) || StringUtils.equals((CharSequence)pgp, (CharSequence)DigestUtils.md5Hex((String)(tk + cyesterday)))) {
                    Cookie cookie = new Cookie(this.serverProperties.getSession().getCookie().getName(), tk.trim());
                    ServerProperties.Session.Cookie cookie1 = this.serverProperties.getSession().getCookie();
                    if (cookie1.getHttpOnly() != null) {
                        cookie.setHttpOnly(cookie1.getHttpOnly().booleanValue());
                    }
                    if (cookie1.getDomain() != null) {
                        cookie.setDomain(cookie1.getDomain());
                    }
                    if (cookie1.getMaxAge() != null) {
                        cookie.setMaxAge(cookie1.getMaxAge().intValue());
                    }
                    if (cookie1.getSecure().booleanValue()) {
                        cookie.setSecure(cookie1.getSecure().booleanValue());
                    }
                    if (cookie1.getPath() != null) {
                        cookie.setPath(cookie1.getPath());
                    }
                    response.addCookie(cookie);
                    StringBuffer backRequestUrl = request.getRequestURL();
                    Boolean firstFlag = true;
                    Map map = request.getParameterMap();
                    for (String s : map.keySet()) {
                        if (StringUtils.equals((CharSequence)"tk", (CharSequence)s) || StringUtils.equals((CharSequence)"pgp", (CharSequence)s)) continue;
                        if (firstFlag.booleanValue()) {
                            backRequestUrl.append("?" + s + "=" + map.get(s));
                            firstFlag = false;
                            continue;
                        }
                        backRequestUrl.append("&" + s + "=" + map.get(s));
                    }
                    response.sendRedirect(backRequestUrl.toString());
                    return;
                }
            }
            if (request.getMethod() != null || "get".equals(request.getMethod().toLowerCase().trim())) {
                if (this.matcher.match(this.loginUrl, requestUrl)) {
                    request.getSession().setAttribute("login_back_url", (Object)this.defaultSuccessUrl);
                } else {
                    StringBuffer url = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        url.append('?');
                        url.append(request.getQueryString());
                    }
                    request.getSession().setAttribute("login_back_url", (Object)url.toString());
                }
            } else {
                request.getSession().setAttribute("login_back_url", (Object)this.defaultSuccessUrl);
            }
            response.sendRedirect(this.loginUrl);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
        super.initBeanWrapper(bw);
        if (this.getFilterConfig().getInitParameter("loginUrl") != null) {
            this.setLoginUrl(this.getFilterConfig().getInitParameter("loginUrl"));
        }
        if (this.getFilterConfig().getInitParameter("checkUrls") != null) {
            this.setCheckUrls(this.getFilterConfig().getInitParameter("checkUrls"));
        }
        if (this.getFilterConfig().getInitParameter("excludeUrls") != null) {
            this.setExcludeUrls(this.getFilterConfig().getInitParameter("excludeUrls"));
        }
        if (this.getFilterConfig().getInitParameter("defaultSuccessUrl") != null) {
            this.setDefaultSuccessUrl(this.getFilterConfig().getInitParameter("defaultSuccessUrl"));
        }
    }

    public void setLoginUrl(String loginUrl) {
        if (!StringUtils.isNotBlank((CharSequence)loginUrl)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u767b\u5f55url");
        }
        this.loginUrl = loginUrl;
    }

    public void setDefaultSuccessUrl(String defaultSuccessUrl) {
        this.defaultSuccessUrl = defaultSuccessUrl;
    }

    public void setCheckUrls(String checkUrls) {
        if (StringUtils.isNotBlank((CharSequence)checkUrls)) {
            this.checkUrls = checkUrls.split(",");
        }
    }

    public void setExcludeUrls(String excludeUrls) {
        if (StringUtils.isNotBlank((CharSequence)excludeUrls)) {
            this.excludeUrls = excludeUrls.split(",");
        }
    }
}

