/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.lang;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.log.Log;
import sinosoftgz.utils.log.Logs;

public class OID {
    private static Log log = Logs.getLog();
    private static AtomicInteger _nextInc = new AtomicInteger(new Random().nextInt());
    private static final int _genmachine;
    private int _time = (int)(System.currentTimeMillis() / 1000L);
    private int _machine = _genmachine;
    private int _inc = _nextInc.getAndIncrement();

    public byte[] toByteArray() {
        byte[] b = new byte[12];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(this._time);
        bb.putInt(this._machine);
        bb.putInt(this._inc);
        return b;
    }

    public String toString() {
        byte[] b = this.toByteArray();
        StringBuilder buf = new StringBuilder(24);
        for (int i = 0; i < b.length; ++i) {
            int x = b[i] & 0xFF;
            String s = Integer.toHexString(x);
            if (s.length() == 1) {
                buf.append("0");
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println(new OID());
        final Set<String> idSet = Lang.newSet(new String[0]);
        System.out.println(Lang.timing(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 1000000; ++i) {
                    String id = new OID().toString();
                    if (idSet.contains(id)) {
                        throw new RuntimeException();
                    }
                    idSet.add(id);
                }
            }
        }));
    }

    static {
        try {
            int machinePiece;
            try {
                StringBuilder sb = new StringBuilder();
                Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
                while (e.hasMoreElements()) {
                    NetworkInterface ni = e.nextElement();
                    sb.append(ni.toString());
                }
                machinePiece = sb.toString().hashCode() << 16;
            }
            catch (Throwable e) {
                log.warn(e);
                machinePiece = new Random().nextInt() << 16;
            }
            log.debug("machine piece post: {}", Integer.toHexString(machinePiece));
            int processId = new Random().nextInt();
            try {
                processId = ManagementFactory.getRuntimeMXBean().getName().hashCode();
            }
            catch (Throwable ni) {
                // empty catch block
            }
            ClassLoader loader = OID.class.getClassLoader();
            int loaderId = loader != null ? System.identityHashCode(loader) : 0;
            StringBuilder sb = new StringBuilder();
            sb.append(Integer.toHexString(processId));
            sb.append(Integer.toHexString(loaderId));
            int processPiece = sb.toString().hashCode() & 0xFFFF;
            log.debug("process piece: {}", Integer.toHexString(processPiece));
            _genmachine = machinePiece | processPiece;
            log.debug("machine : {}", Integer.toHexString(_genmachine));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

