/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.rpc.motan.filter;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import sinosoftgz.utils.spring.ApplicationContextProvider;

@SpiMeta(name="opensession")
@Activation(sequence=100)
public class OpenSessionInMotanFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(OpenSessionInMotanFilter.class);
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response filter(Caller<?> caller, Request request) {
        SessionFactory sessionFactory = this.lookupSessionFactory();
        try {
            Response response;
            Session session = this.openSession(sessionFactory);
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)sessionHolder);
            Response response2 = response = caller.call(request);
            return response2;
        }
        finally {
            try {
                SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
                SessionFactoryUtils.closeSession((Session)sessionHolder.getSession());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter");
        }
        return (SessionFactory)ApplicationContextProvider.getApplicationContext().getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        try {
            Session session = sessionFactory.openSession();
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }
}

