/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.sql;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.sql.PageVo;

@Component
public class QueryByPage {
    @Autowired
    JdbcTemplate jdbcTemplate;

    public <T> PageVo<T> query(String sql, Class<T> elementType, Integer page, Integer pageSize, Object ... args) throws Exception {
        sql = sql.toLowerCase();
        SqlReCreateFactory sqlReCreateFactory = new SqlReCreateFactory(sql, page, pageSize, args).invoke();
        sql = sqlReCreateFactory.getSql();
        List<Object> argsList = sqlReCreateFactory.getArgsList();
        PageVo pageVo = sqlReCreateFactory.getPageVo();
        List result = this.jdbcTemplate.queryForList(sql, elementType, argsList.toArray());
        pageVo.setResult(result);
        return pageVo;
    }

    public PageVo query(String sql, Integer page, Integer pageSize, Object ... args) throws Exception {
        sql = sql.toLowerCase();
        SqlReCreateFactory sqlReCreateFactory = new SqlReCreateFactory(sql, page, pageSize, args).invoke();
        sql = sqlReCreateFactory.getSql();
        List<Object> argsList = sqlReCreateFactory.getArgsList();
        PageVo pageVo = sqlReCreateFactory.getPageVo();
        List result = this.jdbcTemplate.queryForList(sql, argsList.toArray());
        pageVo.setResult(result);
        return pageVo;
    }

    private class SqlReCreateFactory<T> {
        private String sql;
        private Integer page;
        private Integer pageSize;
        private Object[] args;
        private PageVo<T> pageVo;
        private List<Object> argsList;

        public SqlReCreateFactory(String sql, Integer page, Integer pageSize, Object ... args) {
            this.sql = sql;
            this.page = page;
            this.pageSize = pageSize;
            this.args = args;
        }

        public String getSql() {
            return this.sql;
        }

        public PageVo<T> getPageVo() {
            return this.pageVo;
        }

        public List<Object> getArgsList() {
            return this.argsList;
        }

        public SqlReCreateFactory invoke() {
            this.pageVo = new PageVo(0, this.pageSize);
            String sqlCount = "select count(*) from (" + this.sql + ")  ";
            Integer count = (Integer)QueryByPage.this.jdbcTemplate.queryForObject(sqlCount, this.args, Integer.class);
            this.pageVo.setTotalCount(count);
            int pageNum = 0;
            if (count != null && count > 0) {
                pageNum = count % this.pageSize == 0 ? count / this.pageSize : count / this.pageSize + 1;
                this.pageVo.setPageNum(pageNum);
            }
            int pageMin = (this.page - 1) * this.pageSize;
            int pageMax = pageMin + this.pageSize;
            this.argsList = new ArrayList<Object>();
            for (Object arg : this.args) {
                this.argsList.add(arg);
            }
            this.argsList.add(pageMin);
            this.argsList.add(pageMax);
            this.sql = "select p.* from (select t.* ,rownum rownumber from  (" + this.sql + ") t) p where p.rownumber>? and p.rownumber<=? ";
            return this;
        }
    }
}

