/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.sql.dialects.jdialects;

import sinosoftgz.utils.sql.dialects.jdialects.Dialect;
import sinosoftgz.utils.sql.dialects.jdialects.StrUtils;

public class DDLFeatures {
    private static final String NOT_SUPPORT = "NOT_SUPPORT";
    protected String addColumnString;
    protected String addColumnSuffixString;
    protected String addForeignKeyConstraintString;
    protected String addPrimaryKeyConstraintString;
    protected String createCatalogCommand;
    protected String createPooledSequenceStrings;
    protected String createSchemaCommand;
    protected String createSequenceStrings;
    protected String createTableString;
    protected String currentSchemaCommand;
    protected String dropCatalogCommand;
    protected String dropForeignKeyString;
    protected String dropSchemaCommand;
    protected String dropSequenceStrings;
    protected String dropTableString;
    protected Boolean hasAlterTable;
    protected Boolean needDropConstraintsBeforeDropTable;
    protected Boolean supportsCommentOn;
    protected Boolean supportsIfExistsAfterConstraintName;
    protected Boolean supportsIfExistsAfterTableName;
    protected Boolean supportsIfExistsBeforeConstraintName;
    protected Boolean supportsIfExistsBeforeTableName;
    protected Boolean supportsPooledSequences;
    protected Boolean supportsSequences;
    protected String identityColumnString;
    protected String identityColumnStringBigINT;
    protected String identityInsertString;
    protected String identitySelectString;
    protected Boolean hasDataTypeInIdentityColumn;
    protected Boolean supportsIdentityColumns;
    protected Boolean supportsInsertSelectIdentity;

    protected static boolean isValidString(String featureValue) {
        return !StrUtils.isEmpty(featureValue) && !NOT_SUPPORT.equals(featureValue);
    }

    protected static void initDDLFeatures(Dialect dia, DDLFeatures ddl) {
        switch (dia) {
            case SQLiteDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = NOT_SUPPORT;
                ddl.addPrimaryKeyConstraintString = NOT_SUPPORT;
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = false;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "integer";
                ddl.identityColumnStringBigINT = "integer";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_rowid()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case AccessDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case ExcelDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case TextDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = false;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case ParadoxDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case CobolDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = false;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case XMLDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case DbfDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = NOT_SUPPORT;
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Cache71Dialect: {
                ddl.addColumnString = " add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " ADD CONSTRAINT _FKEYNAME FOREIGN KEY _FKEYNAME (_FK1, _FK2) REFERENCES _REFTABLE (_REF1, _REF2) ";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity";
                ddl.identityColumnStringBigINT = "identity";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "SELECT LAST_IDENTITY() FROM %TSQL_sys.snf";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case CUBRIDDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create serial _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create serial _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop serial _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case DataDirectOracle9Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case DB2Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "values identity_val_local()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case DB2390Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "select identity_val_local() from sysibm.sysdummy1";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = false;
                break;
            }
            case DB2400Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "select identity_val_local() from sysibm.sysdummy1";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = false;
                break;
            }
            case DerbyDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "values identity_val_local()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = false;
                break;
            }
            case DerbyTenFiveDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "values identity_val_local()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = false;
                break;
            }
            case DerbyTenSevenDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "values identity_val_local()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case DerbyTenSixDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "values identity_val_local()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case FirebirdDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create generator _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop generator _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case FrontBaseDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case H2Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME if exists";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity";
                ddl.identityColumnStringBigINT = "generated by default as identity";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "call identity()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = true;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case HANAColumnStoreDialect: {
                ddl.addColumnString = "add (";
                ddl.addColumnSuffixString = ")";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE on update cascade";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create column table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case HANARowStoreDialect: {
                ddl.addColumnString = "add (";
                ddl.addColumnSuffixString = ")";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE on update cascade";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case HSQLDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ start with 1";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME if exists";
                ddl.dropTableString = "drop table _TABLENAME if exists";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity (start with 1)";
                ddl.identityColumnStringBigINT = "generated by default as identity (start with 1)";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "call identity()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = true;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case InformixDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint  foreign key (_FK1, _FK2) references _REFTABLE constraint _FKEYNAME";
                ddl.addPrimaryKeyConstraintString = " add constraint primary key constraint _PKEYNAME ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "serial8 not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Informix10Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint  foreign key (_FK1, _FK2) references _REFTABLE constraint _FKEYNAME";
                ddl.addPrimaryKeyConstraintString = " add constraint primary key constraint _PKEYNAME ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "serial8 not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select dbinfo('sqlca.sqlerrd1') from informix.systables where tabid=1";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case IngresDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case Ingres10Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null generated by default as identity";
                ddl.identityColumnStringBigINT = "not null generated by default as identity";
                ddl.identityInsertString = "default";
                ddl.identitySelectString = "select last_identity()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Ingres9Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_identity()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case InterbaseDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create generator _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "delete from RDB$GENERATORS where RDB$GENERATOR_NAME = '_SEQNAME'";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case JDataStoreDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "autoincrement";
                ddl.identityColumnStringBigINT = "autoincrement";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MariaDBDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MariaDB53Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MckoiDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case MimerSQLDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create unique sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME restrict";
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case MySQLDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQL5Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQL55Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQL57Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQL57InnoDBDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQL5InnoDBDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQLInnoDBDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case MySQLMyISAMDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE (_REF1, _REF2)";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = "create database _CATALOGNAME";
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = NOT_SUPPORT;
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = "drop database _CATALOGNAME";
                ddl.dropForeignKeyString = " drop foreign key ";
                ddl.dropSchemaCommand = NOT_SUPPORT;
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table if exists _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "not null auto_increment";
                ddl.identityColumnStringBigINT = "not null auto_increment";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select last_insert_id()";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case OracleDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Oracle10gDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Oracle12cDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated as identity";
                ddl.identityColumnStringBigINT = "generated as identity";
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Oracle8iDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Oracle9Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case Oracle9iDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade constraints";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PointbaseDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case PostgresPlusDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQLDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL81Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL82Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL9Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL91Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL92Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL93Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL94Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case PostgreSQL95Dialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start 11 increment 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence if exists _SEQNAME";
                ddl.dropTableString = "drop table if exists _TABLENAME cascade";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = false;
                ddl.identityColumnString = "serial not null";
                ddl.identityColumnStringBigINT = "bigserial not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select currval('_table__col_seq')";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = true;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = true;
                ddl.supportsIfExistsBeforeTableName = true;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case ProgressDialect: {
                ddl.addColumnString = "add column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = false;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case RDMSOS2200Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "";
                ddl.dropTableString = "drop table _TABLENAME including contents";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case SAPDBDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " foreign key _FKEYNAME (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
            case SQLServerDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SQLServer2005Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SQLServer2008Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SQLServer2012Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = "create sequence _SEQNAME start with 11 increment by 33";
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = true;
                ddl.supportsSequences = true;
                break;
            }
            case SybaseDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case Sybase11Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SybaseAnywhereDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = false;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SybaseASE15Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case SybaseASE157Dialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "identity not null";
                ddl.identityColumnStringBigINT = "identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = "select @@identity";
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = true;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case TeradataDialect: {
                ddl.addColumnString = "Add Column";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case Teradata14Dialect: {
                ddl.addColumnString = "Add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = NOT_SUPPORT;
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = NOT_SUPPORT;
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = "generated by default as identity not null";
                ddl.identityColumnStringBigINT = "generated by default as identity not null";
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = true;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = false;
                break;
            }
            case TimesTenDialect: {
                ddl.addColumnString = "add";
                ddl.addColumnSuffixString = "";
                ddl.addForeignKeyConstraintString = " add constraint _FKEYNAME foreign key (_FK1, _FK2) references _REFTABLE";
                ddl.addPrimaryKeyConstraintString = " add constraint _PKEYNAME primary key ";
                ddl.createCatalogCommand = NOT_SUPPORT;
                ddl.createPooledSequenceStrings = NOT_SUPPORT;
                ddl.createSchemaCommand = "create schema _SCHEMANAME";
                ddl.createSequenceStrings = "create sequence _SEQ";
                ddl.createTableString = "create table";
                ddl.currentSchemaCommand = "";
                ddl.dropCatalogCommand = NOT_SUPPORT;
                ddl.dropForeignKeyString = " drop constraint ";
                ddl.dropSchemaCommand = "drop schema _SCHEMANAME";
                ddl.dropSequenceStrings = "drop sequence _SEQNAME";
                ddl.dropTableString = "drop table _TABLENAME";
                ddl.hasAlterTable = true;
                ddl.hasDataTypeInIdentityColumn = true;
                ddl.identityColumnString = NOT_SUPPORT;
                ddl.identityColumnStringBigINT = NOT_SUPPORT;
                ddl.identityInsertString = "";
                ddl.identitySelectString = NOT_SUPPORT;
                ddl.needDropConstraintsBeforeDropTable = true;
                ddl.supportsCommentOn = false;
                ddl.supportsIdentityColumns = false;
                ddl.supportsIfExistsAfterConstraintName = false;
                ddl.supportsIfExistsAfterTableName = false;
                ddl.supportsIfExistsBeforeConstraintName = false;
                ddl.supportsIfExistsBeforeTableName = false;
                ddl.supportsInsertSelectIdentity = false;
                ddl.supportsPooledSequences = false;
                ddl.supportsSequences = true;
                break;
            }
        }
    }
}

