/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.sql.dialects.jdialects;

import java.sql.Connection;
import java.util.EnumMap;
import java.util.Map;
import javax.sql.DataSource;
import sinosoftgz.utils.sql.dialects.hibernate.StringHelper;
import sinosoftgz.utils.sql.dialects.hibernate.pagination.RowSelection;
import sinosoftgz.utils.sql.dialects.hibernate.pagination.SQLServer2005LimitHandler;
import sinosoftgz.utils.sql.dialects.hibernate.pagination.SQLServer2012LimitHandler;
import sinosoftgz.utils.sql.dialects.jdialects.DDLFeatures;
import sinosoftgz.utils.sql.dialects.jdialects.DDLUtils;
import sinosoftgz.utils.sql.dialects.jdialects.DialectColumn;
import sinosoftgz.utils.sql.dialects.jdialects.DialectConstraint;
import sinosoftgz.utils.sql.dialects.jdialects.DialectException;
import sinosoftgz.utils.sql.dialects.jdialects.DialectLogger;
import sinosoftgz.utils.sql.dialects.jdialects.GuessDialectUtils;
import sinosoftgz.utils.sql.dialects.jdialects.InitPaginationTemplate;
import sinosoftgz.utils.sql.dialects.jdialects.InitTypeMapping;
import sinosoftgz.utils.sql.dialects.jdialects.ReservedDBWords;
import sinosoftgz.utils.sql.dialects.jdialects.StrUtils;
import sinosoftgz.utils.sql.dialects.jdialects.Type;

public enum Dialect {
    SQLiteDialect,
    AccessDialect,
    ExcelDialect,
    TextDialect,
    ParadoxDialect,
    CobolDialect,
    XMLDialect,
    DbfDialect,
    DerbyDialect,
    OracleDialect,
    Oracle9Dialect,
    Cache71Dialect,
    CUBRIDDialect,
    DerbyTenFiveDialect,
    DataDirectOracle9Dialect,
    DB2Dialect,
    DB2390Dialect,
    DB2400Dialect,
    DerbyTenSevenDialect,
    DerbyTenSixDialect,
    FirebirdDialect,
    FrontBaseDialect,
    H2Dialect,
    HANAColumnStoreDialect,
    HANARowStoreDialect,
    HSQLDialect,
    InformixDialect,
    Informix10Dialect,
    IngresDialect,
    Ingres10Dialect,
    Ingres9Dialect,
    InterbaseDialect,
    JDataStoreDialect,
    MariaDBDialect,
    MariaDB53Dialect,
    MckoiDialect,
    MimerSQLDialect,
    MySQLDialect,
    MySQL5Dialect,
    MySQL55Dialect,
    MySQL57Dialect,
    MySQL57InnoDBDialect,
    MySQL5InnoDBDialect,
    MySQLInnoDBDialect,
    MySQLMyISAMDialect,
    Oracle8iDialect,
    Oracle9iDialect,
    Oracle10gDialect,
    Oracle12cDialect,
    PointbaseDialect,
    PostgresPlusDialect,
    PostgreSQLDialect,
    PostgreSQL81Dialect,
    PostgreSQL82Dialect,
    PostgreSQL9Dialect,
    PostgreSQL91Dialect,
    PostgreSQL92Dialect,
    PostgreSQL93Dialect,
    PostgreSQL94Dialect,
    PostgreSQL95Dialect,
    ProgressDialect,
    RDMSOS2200Dialect,
    SAPDBDialect,
    SQLServerDialect,
    SQLServer2005Dialect,
    SQLServer2008Dialect,
    SQLServer2012Dialect,
    SybaseDialect,
    Sybase11Dialect,
    SybaseAnywhereDialect,
    SybaseASE15Dialect,
    SybaseASE157Dialect,
    TeradataDialect,
    Teradata14Dialect,
    TimesTenDialect;

    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String SKIP_ROWS_PLUS1 = "$SKIP_ROWS_PLUS1";
    private static final String TOTAL_ROWS_PLUS1 = "$TOTAL_ROWS_PLUS1";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    DialectLogger logger = DialectLogger.getLog(Dialect.class);
    private String sqlTemplate = null;
    private String topLimitTemplate = null;
    protected final Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);
    protected final DDLFeatures ddlFeatures = new DDLFeatures();

    public static Dialect guessDialect(String databaseName, Object ... majorVersionMinorVersion) {
        return GuessDialectUtils.guessDialect(databaseName, majorVersionMinorVersion);
    }

    public static Dialect guessDialect(Connection connection) {
        return GuessDialectUtils.guessDialect(connection);
    }

    public static Dialect guessDialect(DataSource datasource) {
        return GuessDialectUtils.guessDialect(datasource);
    }

    private void checkIfReservedWord(Dialect dialect, String word) {
        if (ReservedDBWords.isReservedWord(word)) {
            String reservedForDB = ReservedDBWords.reservedForDB(word);
            if (ReservedDBWords.isReservedWord(dialect, word)) {
                DialectException.throwEX("\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table or column name");
            } else {
                this.logger.warn("\"" + word + "\" is a reserved word of other database \"" + reservedForDB + "\", not recommended to be used as table or column name");
            }
        }
    }

    public String check(String word) {
        this.checkIfReservedWord(this, word);
        return word;
    }

    private String translateToDDLType(String colName, Type type, int ... lengths) {
        this.checkIfReservedWord(this, colName);
        return colName + " " + this.translateToDDLType(type, lengths);
    }

    private String translateToDDLType(Type type, int ... lengths) {
        String value = this.typeMappings.get((Object)type);
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + (Object)((Object)this) + "\"");
        }
        if (value.contains("|")) {
            String[] mappings;
            for (String mapping : mappings = StringHelper.split("|", value)) {
                if (mapping.contains("<")) {
                    String[] limitType = StringHelper.split("<", mapping);
                    if (lengths.length <= 0 || lengths[0] >= Integer.parseInt(limitType[1])) continue;
                    return this.putParamters(type, limitType[0], lengths);
                }
                return this.putParamters(type, mapping, lengths);
            }
        } else {
            if (value.contains("$")) {
                return this.putParamters(type, value, lengths);
            }
            return value;
        }
        return "";
    }

    private String putParamters(Type type, String value, int ... lengths) {
        if (lengths.length < StrUtils.countMatches(value, '$')) {
            DialectException.throwEX("In Dialect \"" + (Object)((Object)this) + "\", Type \"" + (Object)((Object)type) + "\" should have " + StrUtils.countMatches(value, '$') + " parameters");
        }
        int i = 0;
        String newValue = value;
        if (newValue.contains("$l")) {
            newValue = StrUtils.replace(newValue, "$l", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(lengths[i++]));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(lengths[i]));
        }
        return newValue;
    }

    public String LONG() {
        return this.translateToDDLType(Type.BIGINT, new int[0]);
    }

    public String BOOLEAN() {
        return this.translateToDDLType(Type.BOOLEAN, new int[0]);
    }

    public String DOUBLE() {
        return this.translateToDDLType(Type.DOUBLE, new int[0]);
    }

    public String FLOAT() {
        return this.translateToDDLType(Type.FLOAT, new int[0]);
    }

    public String INTEGER() {
        return this.translateToDDLType(Type.INTEGER, new int[0]);
    }

    public String SHORT() {
        return this.translateToDDLType(Type.SMALLINT, new int[0]);
    }

    public String BIGDECIMAL(int precision, int scale) {
        return this.translateToDDLType(Type.NUMERIC, precision, scale);
    }

    public String STRING(int length) {
        return this.translateToDDLType(Type.VARCHAR, length);
    }

    public String DATE() {
        return this.translateToDDLType(Type.DATE, new int[0]);
    }

    public String TIME() {
        return this.translateToDDLType(Type.TIME, new int[0]);
    }

    public String TIMESTAMP() {
        return this.translateToDDLType(Type.TIMESTAMP, new int[0]);
    }

    public String BIGINT() {
        return this.translateToDDLType(Type.BIGINT, new int[0]);
    }

    public String BINARY(int ... lengths) {
        return this.translateToDDLType(Type.BINARY, lengths);
    }

    public String BIT() {
        return this.translateToDDLType(Type.BIT, new int[0]);
    }

    public String BLOB(int ... lengths) {
        return this.translateToDDLType(Type.BLOB, lengths);
    }

    public String CHAR(int ... lengths) {
        return this.translateToDDLType(Type.CHAR, lengths);
    }

    public String CLOB(int ... lengths) {
        return this.translateToDDLType(Type.CLOB, lengths);
    }

    public String DECIMAL(int ... lengths) {
        return this.translateToDDLType(Type.DECIMAL, lengths);
    }

    public String JAVA_OBJECT() {
        return this.translateToDDLType(Type.JAVA_OBJECT, new int[0]);
    }

    public String LONGNVARCHAR(int length) {
        return this.translateToDDLType(Type.LONGNVARCHAR, length);
    }

    public String LONGVARBINARY(int ... lengths) {
        return this.translateToDDLType(Type.LONGVARBINARY, lengths);
    }

    public String LONGVARCHAR(int ... lengths) {
        return this.translateToDDLType(Type.LONGVARCHAR, lengths);
    }

    public String NCHAR(int length) {
        return this.translateToDDLType(Type.NCHAR, length);
    }

    public String NCLOB() {
        return this.translateToDDLType(Type.NCLOB, new int[0]);
    }

    public String NUMERIC(int ... lengths) {
        return this.translateToDDLType(Type.NUMERIC, lengths);
    }

    public String NVARCHAR(int length) {
        return this.translateToDDLType(Type.NVARCHAR, length);
    }

    public String OTHER(int ... lengths) {
        return this.translateToDDLType(Type.OTHER, lengths);
    }

    public String REAL() {
        return this.translateToDDLType(Type.REAL, new int[0]);
    }

    public String SMALLINT() {
        return this.translateToDDLType(Type.SMALLINT, new int[0]);
    }

    public String TINYINT() {
        return this.translateToDDLType(Type.TINYINT, new int[0]);
    }

    public String VARBINARY(int ... lengths) {
        return this.translateToDDLType(Type.VARBINARY, lengths);
    }

    public String VARCHAR(int length) {
        return this.translateToDDLType(Type.VARCHAR, length);
    }

    public String LONG(String colName) {
        return this.translateToDDLType(colName, Type.BIGINT, new int[0]);
    }

    public String BOOLEAN(String colName) {
        return this.translateToDDLType(colName, Type.BOOLEAN, new int[0]);
    }

    public String DOUBLE(String colName) {
        return this.translateToDDLType(colName, Type.DOUBLE, new int[0]);
    }

    public String FLOAT(String colName) {
        return this.translateToDDLType(colName, Type.FLOAT, new int[0]);
    }

    public String INTEGER(String colName) {
        return this.translateToDDLType(colName, Type.INTEGER, new int[0]);
    }

    public String SHORT(String colName) {
        return this.translateToDDLType(colName, Type.SMALLINT, new int[0]);
    }

    public String BIGDECIMAL(String colName, int precision, int scale) {
        return this.translateToDDLType(colName, Type.NUMERIC, precision, scale);
    }

    public String STRING(String colName, int length) {
        return this.translateToDDLType(colName, Type.VARCHAR, length);
    }

    public String DATE(String colName) {
        return this.translateToDDLType(colName, Type.DATE, new int[0]);
    }

    public String TIME(String colName) {
        return this.translateToDDLType(colName, Type.TIME, new int[0]);
    }

    public String TIMESTAMP(String colName) {
        return this.translateToDDLType(colName, Type.TIMESTAMP, new int[0]);
    }

    public String BIGINT(String colName) {
        return this.translateToDDLType(colName, Type.BIGINT, new int[0]);
    }

    public String BINARY(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.BINARY, lengths);
    }

    public String BIT(String colName) {
        return this.translateToDDLType(colName, Type.BIT, new int[0]);
    }

    public String BLOB(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.BLOB, lengths);
    }

    public String CHAR(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.CHAR, lengths);
    }

    public String CLOB(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.CLOB, lengths);
    }

    public String DECIMAL(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.DECIMAL, lengths);
    }

    public String JAVA_OBJECT(String colName) {
        return this.translateToDDLType(colName, Type.JAVA_OBJECT, new int[0]);
    }

    public String LONGNVARCHAR(String colName, int length) {
        return this.translateToDDLType(colName, Type.LONGNVARCHAR, length);
    }

    public String LONGVARBINARY(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.LONGVARBINARY, lengths);
    }

    public String LONGVARCHAR(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.LONGVARCHAR, lengths);
    }

    public String NCHAR(String colName, int length) {
        return this.translateToDDLType(colName, Type.NCHAR, length);
    }

    public String NCLOB(String colName) {
        return this.translateToDDLType(colName, Type.NCLOB, new int[0]);
    }

    public String NUMERIC(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.NUMERIC, lengths);
    }

    public String NVARCHAR(String colName, int length) {
        return this.translateToDDLType(colName, Type.NVARCHAR, length);
    }

    public String OTHER(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.OTHER, lengths);
    }

    public String REAL(String colName) {
        return this.translateToDDLType(colName, Type.REAL, new int[0]);
    }

    public String SMALLINT(String colName) {
        return this.translateToDDLType(colName, Type.SMALLINT, new int[0]);
    }

    public String TINYINT(String colName) {
        return this.translateToDDLType(colName, Type.TINYINT, new int[0]);
    }

    public String VARBINARY(String colName, int ... lengths) {
        return this.translateToDDLType(colName, Type.VARBINARY, lengths);
    }

    public String VARCHAR(String colName, int length) {
        return this.translateToDDLType(colName, Type.VARCHAR, length);
    }

    public String engine(String ... extraStrings) {
        String value = this.typeMappings.get((Object)Type.ENGINE);
        if (StrUtils.isEmpty(value)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : extraStrings) {
            sb.append(str);
        }
        return value + sb.toString();
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    private static String processSQLServer(Dialect dialect, int pageNumber, int pageSize, String sql) {
        int skipRows = (pageNumber - 1) * pageSize;
        int totalRows = pageNumber * pageSize;
        RowSelection selection = new RowSelection(skipRows, totalRows);
        String result = null;
        switch (dialect) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: {
                result = new SQLServer2005LimitHandler().processSql(sql, selection);
                break;
            }
            case SQLServer2012Dialect: {
                result = new SQLServer2012LimitHandler().processSql(sql, selection);
                break;
            }
        }
        result = StringHelper.replace(result, "__hibernate_row_nr__", "_ROW_NUM_");
        result = StringHelper.replaceOnce(result, " $Top_Tag(?) ", " TOP(" + totalRows + ") ");
        result = StringHelper.replaceOnce(result, "_ROW_NUM_ >= ? AND _ROW_NUM_ < ?", "_ROW_NUM_ >= " + (skipRows + 1) + " AND _ROW_NUM_ < " + (totalRows + 1));
        result = StringHelper.replaceOnce(result, "offset ? rows fetch next ? rows only", "offset " + skipRows + " rows fetch next " + pageSize + " rows only");
        result = StringHelper.replaceOnce(result, "offset 0 rows fetch next ? rows only", "offset 0 rows fetch next " + pageSize + " rows only");
        if (StrUtils.isEmpty(result)) {
            return (String)DialectException.throwEX("Unexpected error, please report this bug");
        }
        return result;
    }

    public String paginate(int pageNumber, int pageSize, String sql) {
        switch (this) {
            case SQLServer2005Dialect: 
            case SQLServer2008Dialect: 
            case SQLServer2012Dialect: {
                return Dialect.processSQLServer(this, pageNumber, pageSize, sql);
            }
        }
        if (!StrUtils.startsWithIgnoreCase(sql, "select ")) {
            return (String)DialectException.throwEX("SQL should be started with \"select \".");
        }
        String body = sql.substring(7).trim();
        if (StrUtils.isEmpty(body)) {
            return (String)DialectException.throwEX("SQL body can not be null");
        }
        int skipRows = (pageNumber - 1) * pageSize;
        int skipRowsPlus1 = skipRows + 1;
        int totalRows = pageNumber * pageSize;
        int totalRowsPlus1 = totalRows + 1;
        String useTemplate = this.sqlTemplate;
        if (skipRows == 0) {
            useTemplate = this.topLimitTemplate;
        }
        if (NOT_SUPPORT.equals(useTemplate)) {
            if (!NOT_SUPPORT.equals(this.topLimitTemplate)) {
                return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" only support top limit SQL, for example: \"" + Dialect.aTopLimitSqlExample(this.topLimitTemplate) + "\"");
            }
            return (String)DialectException.throwEX("Dialect \"" + (Object)((Object)this) + "\" does not support physical pagination");
        }
        if (useTemplate.contains(DISTINCT_TAG)) {
            if (!StrUtils.startsWithIgnoreCase(body, "distinct ")) {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "");
            } else {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "distinct");
                body = body.substring(9);
            }
        }
        String result = StrUtils.replaceIgnoreCase(useTemplate, SKIP_ROWS, String.valueOf(skipRows));
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, String.valueOf(pageSize));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, String.valueOf(totalRows));
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS_PLUS1, String.valueOf(skipRowsPlus1));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS_PLUS1, String.valueOf(totalRowsPlus1));
        result = StrUtils.replace(result, "$SQL", sql);
        result = StrUtils.replace(result, "$BODY", body);
        return result;
    }

    public boolean isMySqlFamily() {
        return this.toString().startsWith("MySQL");
    }

    public boolean isOracleFamily() {
        return this.toString().startsWith("Oracle");
    }

    public boolean isSQLServerFamily() {
        return this.toString().startsWith("SQLServer");
    }

    public boolean isH2Family() {
        return H2Dialect.equals((Object)this);
    }

    public boolean isPostgresFamily() {
        return this.toString().startsWith("Postgres");
    }

    public boolean isSybaseFamily() {
        return this.toString().startsWith("Sybase");
    }

    public boolean isDB2Family() {
        return this.toString().startsWith("DB2");
    }

    public boolean isDerbyFamily() {
        return this.toString().startsWith("Derby");
    }

    public String createTable(String tableName) {
        return DDLUtils.createTable(this, tableName);
    }

    public DialectColumn column(String columnName, String columnType) {
        return DDLUtils.column(this, columnName, columnType);
    }

    public DialectColumn addColumn(String tableName, String columnName, String columnType) {
        return DDLUtils.addColumn(this, tableName, columnName, columnType);
    }

    public void dropColumn(String tableName, String columnName) {
        DDLUtils.dropColumn(this, tableName, columnName);
    }

    public DialectConstraint constraint(String constraintName, String constraintType) {
        return DDLUtils.constraint(this, constraintName, constraintType);
    }

    public DialectConstraint addConstraint(String tableName, String constraintName, String constraintType) {
        return DDLUtils.addConstraint(this, tableName, constraintName, constraintType);
    }

    public void dropConstraint(String tableName, String constraintName) {
        DDLUtils.dropConstraint(this, tableName, constraintName);
    }

    static {
        for (Dialect d : Dialect.values()) {
            d.sqlTemplate = InitPaginationTemplate.initializePaginSQLTemplate(d);
            d.topLimitTemplate = InitPaginationTemplate.initializeTopLimitSqlTemplate(d);
            InitTypeMapping.initializeTypeMappings(d);
            DDLFeatures.initDDLFeatures(d, d.ddlFeatures);
        }
    }
}

