/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.sql.dialects.jdialects;

import java.util.ArrayList;
import java.util.List;
import sinosoftgz.utils.sql.dialects.jdialects.DDLFeatures;
import sinosoftgz.utils.sql.dialects.jdialects.Dialect;
import sinosoftgz.utils.sql.dialects.jdialects.DialectConstraint;
import sinosoftgz.utils.sql.dialects.jdialects.DialectException;

public class DialectColumn {
    public static final String OPERATION_NO = "NO";
    public static final String OPERATION_ADD = "ADD";
    private String operation = "NO";
    private Dialect dialect;
    private String tableName;
    private String columnName;
    private String columnType;
    private Boolean required;
    private Boolean unique;
    private Boolean autoInc;
    private Boolean pkey;
    private Object defaultValue;
    private List<DialectConstraint> constraints = new ArrayList<DialectConstraint>();

    public DialectColumn(String columnName, String columnType) {
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public DialectColumn required() {
        this.required = true;
        return this;
    }

    public DialectColumn unique() {
        this.unique = true;
        return this;
    }

    public DialectColumn autoInc() {
        this.autoInc = true;
        return this;
    }

    public DialectColumn defaultValue(Object value) {
        this.defaultValue = value;
        return this;
    }

    public DialectColumn pkey() {
        return this.pkey("");
    }

    public DialectColumn pkey(String pkeyName) {
        DialectConstraint cons = new DialectConstraint();
        cons.setConstraintType("PKEY");
        cons.setConstraintName(pkeyName);
        this.constraints.add(cons);
        this.pkey = true;
        return this;
    }

    public String toString() {
        switch (this.operation) {
            case "NO": {
                return this.columnName + " " + this.columnType;
            }
            case "ADD": {
                if (!DDLFeatures.isValidString(this.dialect.ddlFeatures.addColumnString)) {
                    return (String)DialectException.throwEX((Object)((Object)this.dialect) + " does not support add column.");
                }
                return "alter table " + this.dialect.ddlFeatures.addColumnString + " " + this.columnName + " " + this.columnType + this.dialect.ddlFeatures.addColumnSuffixString;
            }
        }
        return (String)DialectException.throwEX("Unknow operation type for DialectColumn");
    }

    public String getTableName() {
        return this.tableName;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public DialectColumn setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public String getOperation() {
        return this.operation;
    }

    public DialectColumn setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public DialectColumn setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DialectColumn setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public DialectColumn setColumnType(String columnType) {
        this.columnType = columnType;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public DialectColumn setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public DialectColumn setUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }

    public Boolean getAutoInc() {
        return this.autoInc;
    }

    public DialectColumn setAutoInc(Boolean autoInc) {
        this.autoInc = autoInc;
        return this;
    }

    public Boolean getPkey() {
        return this.pkey;
    }

    public DialectColumn setPkey(Boolean pkey) {
        this.pkey = pkey;
        return this;
    }

    public List<DialectConstraint> getConstraints() {
        return this.constraints;
    }

    public DialectColumn setConstraints(List<DialectConstraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public DialectColumn setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }
}

