/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.io.UnsafeStringReader;
import sinosoftgz.utils.io.UnsafeStringWriter;

public class Jsons {
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectMapper mapperSerialized = new ObjectMapper();

    private Jsons() {
    }

    public static String toJson(Object obj) {
        UnsafeStringWriter stringWriter = new UnsafeStringWriter();
        try {
            mapper.writeValue((Writer)stringWriter, obj);
        }
        catch (JsonGenerationException e) {
            throw Lang.unchecked(e);
        }
        catch (JsonMappingException e) {
            throw Lang.unchecked(e);
        }
        catch (IOException e) {
            throw Lang.unchecked(e);
        }
        return stringWriter.toString();
    }

    public static String toJsonSerialized(Object obj) {
        UnsafeStringWriter stringWriter = new UnsafeStringWriter();
        try {
            mapperSerialized.writeValue((Writer)stringWriter, obj);
        }
        catch (JsonGenerationException e) {
            throw Lang.unchecked(e);
        }
        catch (JsonMappingException e) {
            throw Lang.unchecked(e);
        }
        catch (IOException e) {
            throw Lang.unchecked(e);
        }
        return stringWriter.toString();
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try (UnsafeStringReader stringReader = new UnsafeStringReader(json);){
            Object object = mapper.readValue((Reader)stringReader, type);
            return (T)object;
        }
    }

    public static <T> T fromJsonSerialized(String json, Class<T> type) {
        try (UnsafeStringReader stringReader = new UnsafeStringReader(json);){
            Object object = mapperSerialized.readValue((Reader)stringReader, type);
            return (T)object;
        }
    }

    static {
        mapperSerialized.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
    }
}

