/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    public static boolean isBankCardNumber(String bankCardNo) {
        if (null == bankCardNo) {
            return false;
        }
        Pattern p = Pattern.compile("^\\d{19}$");
        Matcher m = p.matcher(bankCardNo);
        return m.matches();
    }

    public static boolean isPhoneNumber(String phoneNum) {
        if (null == phoneNum) {
            return false;
        }
        Pattern p = Pattern.compile("^((1[3-8][0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(phoneNum);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        if (null == email) {
            return false;
        }
        String str = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\.][A-Za-z]{2,3}([\\.][A-Za-z]{2})?$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isRightIdentity(String identityCardNum) {
        if (null == identityCardNum) {
            return false;
        }
        Pattern idNumPattern = Pattern.compile("(\\d{14}[0-9a-zA-Z])|(\\d{17}[0-9a-zA-Z])");
        Matcher m = idNumPattern.matcher(identityCardNum);
        return m.matches();
    }
}

