/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class FrontEndLoginCheckFilter
extends OncePerRequestFilter {
    private String loginUrl;
    private String defaultSuccessUrl;
    private String[] checkUrls = new String[0];
    private String[] excludeUrls = new String[0];
    PathMatcher matcher = new AntPathMatcher();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object sessionMemberId;
        String requestUrl = request.getRequestURI();
        for (String excludeUrl : this.excludeUrls) {
            if (!this.matcher.match(excludeUrl, requestUrl)) continue;
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean checkFlag = false;
        for (String checkUrl : this.checkUrls) {
            if (!this.matcher.match(checkUrl, requestUrl)) continue;
            checkFlag = true;
            break;
        }
        if (checkFlag && ((sessionMemberId = request.getSession().getAttribute("member_id")) == null || StringUtils.isBlank((CharSequence)sessionMemberId.toString()))) {
            if (request.getMethod() != null || "get".equals(request.getMethod().toLowerCase().trim())) {
                if (this.matcher.match(this.loginUrl, requestUrl)) {
                    request.getSession().setAttribute("login_back_url", (Object)this.defaultSuccessUrl);
                } else {
                    StringBuffer url = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        url.append('?');
                        url.append(request.getQueryString());
                    }
                    request.getSession().setAttribute("login_back_url", (Object)url.toString());
                }
            } else {
                request.getSession().setAttribute("login_back_url", (Object)this.defaultSuccessUrl);
            }
            response.sendRedirect(this.loginUrl);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void initBeanWrapper(BeanWrapper bw) throws BeansException {
        super.initBeanWrapper(bw);
        if (this.getFilterConfig().getInitParameter("loginUrl") != null) {
            this.setLoginUrl(this.getFilterConfig().getInitParameter("loginUrl"));
        }
        if (this.getFilterConfig().getInitParameter("checkUrls") != null) {
            this.setCheckUrls(this.getFilterConfig().getInitParameter("checkUrls"));
        }
        if (this.getFilterConfig().getInitParameter("excludeUrls") != null) {
            this.setExcludeUrls(this.getFilterConfig().getInitParameter("excludeUrls"));
        }
        if (this.getFilterConfig().getInitParameter("defaultSuccessUrl") != null) {
            this.setDefaultSuccessUrl(this.getFilterConfig().getInitParameter("defaultSuccessUrl"));
        }
    }

    public void setLoginUrl(String loginUrl) {
        if (!StringUtils.isNotBlank((CharSequence)loginUrl)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u767b\u5f55url");
        }
        this.loginUrl = loginUrl;
    }

    public void setDefaultSuccessUrl(String defaultSuccessUrl) {
        this.defaultSuccessUrl = defaultSuccessUrl;
    }

    public void setCheckUrls(String checkUrls) {
        if (StringUtils.isNotBlank((CharSequence)checkUrls)) {
            this.checkUrls = checkUrls.split(",");
        }
    }

    public void setExcludeUrls(String excludeUrls) {
        if (StringUtils.isNotBlank((CharSequence)excludeUrls)) {
            this.excludeUrls = excludeUrls.split(",");
        }
    }
}

