/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.kaptcha;

import com.alibaba.fastjson.JSON;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import sinosoftgz.utils.Lang;

public class CheckUtils {
    @Autowired
    private StringRedisTemplate redisTemplate;

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String checkCaptchaCode(String type, long expire, String code, HttpSession session) {
        Object validatecode = session.getAttribute(type + ":code");
        Object validatedate = session.getAttribute(type + ":date");
        if (validatecode == null) {
            return "\u6821\u9a8c\u7801\u4e0d\u6b63\u786e";
        }
        if (!validatecode.toString().toLowerCase().equals(code.trim().toLowerCase())) {
            return "\u6821\u9a8c\u7801\u4e0d\u6b63\u786e";
        }
        if (validatedate != null && validatedate instanceof Date) {
            Date checkDate = (Date)validatedate;
            long m = System.currentTimeMillis() - checkDate.getTime();
            if (expire < m) {
                return "\u6821\u9a8c\u7801\u5df2\u8fc7\u671f";
            }
        }
        return null;
    }

    public void errorTimeMark(String type, Integer maxTimeWindow, HttpSession session, boolean clusterFlag, String globalKey) {
        Object errorTime = null;
        if (clusterFlag) {
            String mapStr = (String)this.redisTemplate.boundValueOps((Object)globalKey).get();
            errorTime = JSON.parseObject((String)mapStr, HashMap.class);
        } else {
            errorTime = session.getAttribute(type + ":errortime");
        }
        Map<String, Integer> map = null;
        map = errorTime == null || !(errorTime instanceof Map) ? Lang.newLRUMap(maxTimeWindow, new Object[0]) : (Map<String, Integer>)errorTime;
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(14, 0);
        String key = calendar.getTime().toString();
        Object times = map.get(key);
        if (times == null || !(times instanceof Integer)) {
            map.put(key, 1);
        } else {
            Integer i = (Integer)times;
            i = i + 1;
            map.put(key, i);
        }
        if (clusterFlag) {
            this.redisTemplate.boundValueOps((Object)globalKey).set((Object)JSON.toJSONString(map), 24L, TimeUnit.HOURS);
        } else {
            session.setAttribute(type + ":errortime", map);
        }
    }

    public Integer getErrorTime(String type, Integer time, HttpSession session, boolean clusterFlag, String globalKey) {
        Object errorTime;
        if (clusterFlag) {
            String mapStr = (String)this.redisTemplate.boundValueOps((Object)globalKey).get();
            errorTime = JSON.parseObject((String)mapStr, HashMap.class);
        } else {
            errorTime = session.getAttribute(type + ":errortime");
        }
        if (errorTime == null || !(errorTime instanceof Map)) {
            return 0;
        }
        Map map = (Map)errorTime;
        Calendar calendar = Calendar.getInstance();
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(12, 1);
        Integer sum = 0;
        for (int i = 0; i < time; ++i) {
            calendar.roll(12, -1);
            String key = calendar.getTime().toString();
            if (map.get(key) == null) continue;
            sum = sum + (Integer)map.get(key);
        }
        return sum;
    }

    public void resetErrorTime(String type, HttpSession session, boolean clusterFlag, String globalKey) {
        if (clusterFlag) {
            this.redisTemplate.delete((Object)globalKey);
        } else {
            session.removeAttribute(type + ":errortime");
        }
    }

    public String getValidateCode(String type, HttpSession session) {
        Object validatecode = session.getAttribute(type + ":code");
        if (validatecode != null) {
            return validatecode.toString();
        }
        return null;
    }
}

