/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.nginx;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import sinosoftgz.utils.lang.Https;
import sinosoftgz.utils.nginx.NginxProperties;

@Configuration
@EnableConfigurationProperties(value={NginxProperties.class})
@ConditionalOnProperty(value={"enable"}, prefix="nginx")
public class NginxAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NginxAutoConfiguration.class);
    @Autowired
    NginxProperties nginxProperties;
    @Autowired
    private ServerProperties serverProperties;

    public NginxProperties getNginxProperties() {
        return this.nginxProperties;
    }

    public void setNginxProperties(NginxProperties nginxProperties) {
        this.nginxProperties = nginxProperties;
    }

    @PostConstruct
    void registMonitor() throws UnknownHostException {
        if (this.nginxProperties == null || !this.nginxProperties.getEnable().booleanValue()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.nginxProperties.getServerhost())) {
            if (this.serverProperties.getAddress() != null && StringUtils.isNotBlank((CharSequence)this.serverProperties.getAddress().getHostAddress())) {
                stringBuilder.append(this.serverProperties.getAddress().getHostAddress() + ":" + this.serverProperties.getPort());
            } else {
                stringBuilder.append(InetAddress.getLocalHost().getHostAddress() + ":" + this.serverProperties.getPort());
            }
        } else {
            stringBuilder.append(this.nginxProperties.getServerhost());
        }
        final String addressPath = stringBuilder.toString();
        stringBuilder.append(" " + this.nginxProperties.getServerext());
        final String address = stringBuilder.toString();
        logger.info("\u6ce8\u518cweb \u670d\u52a1{}\u5230zookeeper ", (Object)address);
        ZkConnection zkConnection = new ZkConnection(this.nginxProperties.getZookeeperHost(), 6000);
        final ZkClient zkClient = new ZkClient((IZkConnection)zkConnection);
        if (this.nginxProperties.getPushServer().booleanValue()) {
            zkClient.subscribeChildChanges("/nginx/" + this.nginxProperties.getUpstream(), new IZkChildListener(){

                public void handleChildChange(String s, List<String> list) throws Exception {
                    logger.info("{},change {}:{},", new Object[]{NginxAutoConfiguration.this.nginxProperties.getUpstream(), s, list});
                    StringBuilder listStr = new StringBuilder();
                    for (String s1 : list) {
                        listStr.append("server " + s1 + " " + NginxAutoConfiguration.this.nginxProperties.getServerext() + ";");
                    }
                    logger.info(listStr.toString());
                    Https.HttpResponse response = Https.create(NginxAutoConfiguration.this.nginxProperties.getNginxServer() + "/upstream/" + NginxAutoConfiguration.this.nginxProperties.getUpstream()).setContent(listStr.toString()).post();
                    logger.info(response.getContentAsString());
                }
            });
        }
        zkClient.createPersistent("/nginx/" + this.nginxProperties.getUpstream(), true);
        zkClient.create("/nginx/" + this.nginxProperties.getUpstream() + "/" + addressPath, (Object)address, CreateMode.EPHEMERAL);
        logger.info("web \u7ed1\u5b9a\u5230zookeeper {}:{}", (Object)addressPath, (Object)address);
        IZkStateListener zkStateListener = new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
            }

            public void handleNewSession() throws Exception {
                logger.info("zkRegistry get new session notify.");
                if (!zkClient.exists("/nginx/" + NginxAutoConfiguration.this.nginxProperties.getUpstream() + "/" + addressPath)) {
                    logger.info("web \u91cd\u65b0\u7ed1\u5b9a\u5230zookeeper {}:{}", (Object)addressPath, (Object)address);
                    zkClient.create("/nginx/" + NginxAutoConfiguration.this.nginxProperties.getUpstream() + "/" + addressPath, (Object)address, CreateMode.EPHEMERAL);
                }
            }

            public void handleSessionEstablishmentError(Throwable throwable) throws Exception {
                throw new RuntimeException(throwable);
            }
        };
        zkClient.subscribeStateChanges(zkStateListener);
    }
}

