/*
 * Decompiled with CFR 0.152.
 */
package sinosoftgz.utils.string;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import sinosoftgz.utils.Lang;
import sinosoftgz.utils.log.Log;
import sinosoftgz.utils.log.Logs;

public class StringUtils {
    private static final Log log = Logs.getLog();
    public static int LEFT = 1;
    public static int RIGHT = 2;

    public static boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String nullToEmpty(String str) {
        if (str == null) {
            return "";
        }
        return str.toString();
    }

    public static boolean isInArray(String str, String[] strArray) {
        boolean result = false;
        int length = strArray.length;
        for (int i = 0; i < length; ++i) {
            if (!strArray[i].equals(str)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String getDesignedLengthRandom(int length) {
        return String.valueOf(Math.random()).substring(2, length + 2);
    }

    public static boolean isMapParamNull(Map<String, Object> map) {
        boolean isMapParamNull = false;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() != null && !e.getValue().equals("")) continue;
            isMapParamNull = true;
        }
        return isMapParamNull;
    }

    public static String Pading(String str, int totalLenth, int leftOrRight, char padingChar) {
        String rtn = null;
        if (str.length() >= totalLenth) {
            return str;
        }
        int count = totalLenth - str.length();
        char[] padingChars = new char[count];
        for (int i = 0; i < count; ++i) {
            padingChars[i] = padingChar;
        }
        if (leftOrRight == LEFT) {
            rtn = String.valueOf(padingChars) + str;
        } else if (leftOrRight == RIGHT) {
            rtn = str + padingChars.toString();
        } else {
            return str;
        }
        return rtn;
    }

    public static String getSecurityCode() {
        Random rd = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 6; ++i) {
            int _num = rd.nextInt(10);
            sb.append(_num);
        }
        return sb.toString();
    }

    public static boolean isNotBlank(String gotoUrl) {
        return gotoUrl != null && !gotoUrl.isEmpty() && !gotoUrl.trim().isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty() || str.trim().isEmpty();
    }

    public static String newString(String iString, int iTimes) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < iTimes; ++i) {
            buffer.append(iString);
        }
        return buffer.toString();
    }

    public static String space(int iLength) {
        return StringUtils.newString(" ", iLength);
    }

    public static int getLength(String iString) {
        return iString.getBytes().length;
    }

    public static String unicodeToGBK(String iString) throws UnsupportedEncodingException {
        String oString = iString;
        if (iString != null) {
            oString = new String(iString.getBytes("ISO8859_1"), "GBK");
        }
        return oString;
    }

    public static String GBKToUnicode(String iString) throws UnsupportedEncodingException {
        String oString = iString;
        if (iString != null) {
            oString = new String(iString.getBytes("GBK"), "ISO8859_1");
        }
        return oString;
    }

    public static int getPos(String strMain, String strSub, int intTimes) {
        return StringUtils.getPos(strMain, strSub, 0, intTimes);
    }

    public static int getPos(String strMain, String strSub, int intStartIndex, int intTimes) {
        int intCounter = 0;
        int intPosition = intStartIndex;
        int intLength = strSub.length();
        if (intTimes <= 0) {
            return -1;
        }
        if (strMain.length() - 1 < intStartIndex) {
            return -1;
        }
        if (strSub.equals("")) {
            return 0;
        }
        while (intCounter < intTimes) {
            if ((intPosition = strMain.indexOf(strSub, intPosition)) == -1) {
                return -1;
            }
            ++intCounter;
            intPosition += intLength;
        }
        return intPosition - intLength;
    }

    public static void copyFile(String fromFile, String toFile) throws FileNotFoundException, IOException, Exception {
        int len;
        FileInputStream in = new FileInputStream(fromFile);
        FileOutputStream out = new FileOutputStream(toFile);
        byte[] b = new byte[1024];
        while ((len = in.read(b)) != -1) {
            out.write(b, 0, len);
        }
        out.close();
        in.close();
    }

    public static String replace(String strMain, String strFind, String strReplaceWith) {
        String strReturn = "";
        int intStartIndex = 0;
        int intEndIndex = 0;
        if (strMain == null || strMain.equals("")) {
            return "";
        }
        while ((intEndIndex = strMain.indexOf(strFind, intStartIndex)) > -1) {
            strReturn = strReturn + strMain.substring(intStartIndex, intEndIndex) + strReplaceWith;
            intStartIndex = intEndIndex + strFind.length();
        }
        strReturn = strReturn + strMain.substring(intStartIndex, strMain.length());
        return strReturn;
    }

    public static String decodeStr(String strMain, String strDelimiters, int intSerialNo) {
        int posStart = 0;
        int posEnd = 0;
        String strReturn = "";
        if (strMain.length() < strDelimiters.length()) {
            return "";
        }
        posStart = StringUtils.getPos(strMain, strDelimiters, intSerialNo - 1);
        posStart = posStart == -1 ? 0 : (posStart += strDelimiters.length());
        posEnd = StringUtils.getPos(strMain, strDelimiters, intSerialNo);
        if (posEnd == -1) {
            posEnd = 0;
        }
        strReturn = strMain.substring(posStart, posEnd);
        return strReturn;
    }

    public static Vector stringToVector(String strMessage, String delimiter, int intCount, Class cl) throws Exception {
        int intFieldNum = 0;
        Object object = null;
        Vector<Object> vec = new Vector<Object>();
        int intPosition = 0;
        Class[] parameters = new Class[]{String.class};
        Method method = null;
        Field field = null;
        Object[] therecord = new String[]{new String()};
        object = cl.newInstance();
        method = cl.getMethod("decode", parameters);
        field = cl.getField("FIELDNUM");
        intFieldNum = field.getInt(object);
        for (int i = 0; i < intCount; ++i) {
            object = cl.newInstance();
            intPosition = StringUtils.getPos(strMessage, delimiter, intFieldNum);
            therecord[0] = strMessage.substring(0, intPosition + 1);
            method.invoke(object, therecord);
            vec.addElement(object);
            strMessage = strMessage.substring(intPosition + 1);
        }
        return vec;
    }

    public static String toHTMLFormat(String strInValue) {
        String strOutValue = "";
        block7: for (int i = 0; i < strInValue.length(); ++i) {
            char c = strInValue.charAt(i);
            switch (c) {
                case '<': {
                    strOutValue = strOutValue + "&lt;";
                    continue block7;
                }
                case '>': {
                    strOutValue = strOutValue + "&gt;";
                    continue block7;
                }
                case '\n': {
                    strOutValue = strOutValue + "<br>";
                    continue block7;
                }
                case '\r': {
                    continue block7;
                }
                case ' ': {
                    strOutValue = strOutValue + "&nbsp;";
                    continue block7;
                }
                default: {
                    strOutValue = strOutValue + c;
                }
            }
        }
        return strOutValue;
    }

    public static String encode(String strInValue) {
        String strOutValue = "";
        block14: for (int i = 0; i < strInValue.length(); ++i) {
            char c = strInValue.charAt(i);
            switch (c) {
                case ':': {
                    strOutValue = strOutValue + "\uff1a";
                    continue block14;
                }
                case '|': {
                    strOutValue = strOutValue + "\u2503";
                    continue block14;
                }
                case '\n': {
                    strOutValue = strOutValue + "\\n";
                    continue block14;
                }
                case '\r': {
                    strOutValue = strOutValue + "\\r";
                    continue block14;
                }
                case '\"': {
                    strOutValue = strOutValue + "\\\"";
                    continue block14;
                }
                case '\'': {
                    strOutValue = strOutValue + "\\'";
                    continue block14;
                }
                case '\b': {
                    strOutValue = strOutValue + "\\b";
                    continue block14;
                }
                case '\t': {
                    strOutValue = strOutValue + "\\t";
                    continue block14;
                }
                case '\f': {
                    strOutValue = strOutValue + "\\f";
                    continue block14;
                }
                case '\\': {
                    strOutValue = strOutValue + "\\\\";
                    continue block14;
                }
                case '<': {
                    strOutValue = strOutValue + "\\<";
                    continue block14;
                }
                case '>': {
                    strOutValue = strOutValue + "\\>";
                    continue block14;
                }
                default: {
                    strOutValue = strOutValue + c;
                }
            }
        }
        return strOutValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertString(String strName, String strValue, String strSign) {
        String strReturn = "";
        if (strValue == null) return "";
        if (strValue.equals("")) {
            return "";
        }
        if (strSign.equals(":")) {
            String strValueStart = "";
            String strValueEnd = "";
            int index = strValue.indexOf(58);
            if (index <= -1) return "";
            strValueStart = strValue.substring(0, index);
            strValueEnd = strValue.substring(index + 1);
            return " and " + strName + " between '" + strValueStart + "' and '" + strValueEnd + "' ";
        }
        if (strSign.equals("=")) {
            return " and " + strName + "='" + strValue + "' ";
        }
        strValue = StringUtils.replace(strValue, "*", "%");
        return " and " + strName + " like '%" + strValue + "%' ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertDate(String strName, String strValue, String strSign) {
        String strReturn = "";
        String strDbType = "ORACLE";
        if (strValue == null) return "";
        if (strValue.equals("")) {
            return "";
        }
        if (strSign.equals(":")) {
            String strValueStart = "";
            String strValueEnd = "";
            int index = strValue.indexOf(58);
            if (index <= -1) return "";
            strValueStart = strValue.substring(0, index);
            strValueEnd = strValue.substring(index + 1);
            if (!strDbType.equals("ORACLE")) return " and " + strName + " between '" + strValueStart + "' and '" + strValueEnd + "' ";
            return " and " + strName + " between to_date('" + strValueStart + "') and to_date('" + strValueEnd + "') ";
        }
        if (!strDbType.equals("ORACLE")) return " and " + strName + strSign + "'" + strValue + "' ";
        return " and " + strName + strSign + "to_date('" + strValue + "') ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertNumber(String strName, String strValue, String strSign) {
        String strReturn = "";
        if (strValue == null) return "";
        if (strValue.equals("")) {
            return "";
        }
        if (!strSign.equals(":")) return " and " + strName + strSign + "'" + strValue + "' ";
        String strValueStart = "";
        String strValueEnd = "";
        int index = strValue.indexOf(58);
        if (index <= -1) return "";
        strValueStart = strValue.substring(0, index);
        strValueEnd = strValue.substring(index + 1);
        return " and " + strName + " between '" + strValueStart + "' and '" + strValueEnd + "' ";
    }

    public static String decode(String strInValue) {
        String strOutValue = strInValue;
        strOutValue = StringUtils.replace(strOutValue, "\\n", "\n");
        strOutValue = StringUtils.replace(strOutValue, "\\r", "\r");
        strOutValue = StringUtils.replace(strOutValue, "\\\\", "\\");
        strOutValue = StringUtils.replace(strOutValue, "\\b", "\b");
        strOutValue = StringUtils.replace(strOutValue, "\\t", "\t");
        strOutValue = StringUtils.replace(strOutValue, "\\\"", "\"");
        strOutValue = StringUtils.replace(strOutValue, "\\'", "'");
        strOutValue = StringUtils.replace(strOutValue, "\\f", "\f");
        strOutValue = StringUtils.replace(strOutValue, "\\<", "<");
        strOutValue = StringUtils.replace(strOutValue, "\\>", ">");
        return strOutValue;
    }

    public static Object split(String strMain, int intMaxLength) {
        if (strMain == null) {
            return new String[0];
        }
        if (strMain.trim().equals("")) {
            return new String[0];
        }
        byte[] arrByte = new byte[]{};
        int intEndIndex = 0;
        int intStartIndex = 0;
        int intCount = 0;
        int j = 0;
        String[] arrReturn = new String[]{};
        arrByte = strMain.getBytes();
        intCount = Math.round((float)(arrByte.length / intMaxLength) + 0.5f);
        arrReturn = new String[intCount];
        for (int i = 0; i < intCount; ++i) {
            intEndIndex = intEndIndex == 0 ? intMaxLength - 1 : (intEndIndex += intMaxLength);
            intEndIndex = Math.min(intEndIndex, arrByte.length - 1);
            if (arrByte[intEndIndex] < 0) {
                j = intEndIndex - 1;
                while (arrByte[j] < 0 && --j >= intStartIndex) {
                }
                if ((intEndIndex - j) % 2 != 0) {
                    --intEndIndex;
                }
            }
            arrReturn[i] = new String(arrByte, intStartIndex, intEndIndex - intStartIndex + 1);
            if (intEndIndex == arrByte.length - 1) break;
            intStartIndex = intEndIndex + 1;
        }
        return arrReturn;
    }

    public static String chgStrZero(String iValue) {
        String value = null;
        value = iValue == null ? "0" : (iValue.trim().length() == 0 ? "0" : iValue);
        return value.trim();
    }

    public static String getYear() {
        String strReturn = "";
        int intYear = Calendar.getInstance().get(1);
        strReturn = "" + intYear;
        return strReturn;
    }

    public static String getMonth() {
        String strReturn = "";
        int intMonth = Calendar.getInstance().get(2) + 1;
        strReturn = intMonth < 10 ? "0" + intMonth : "" + intMonth;
        return strReturn;
    }

    public static String getDay() {
        String strReturn = "";
        int intDate = Calendar.getInstance().get(5);
        strReturn = intDate < 10 ? "0" + intDate : "" + intDate;
        return strReturn;
    }

    public static String getHour() {
        String strReturn = "";
        int intHour = Calendar.getInstance().get(10) + 12 * Calendar.getInstance().get(9);
        strReturn = intHour < 10 ? "0" + intHour : "" + intHour;
        return strReturn;
    }

    public static String getMinute() {
        String strReturn = "";
        int intMinute = Calendar.getInstance().get(12);
        strReturn = intMinute < 10 ? "0" + intMinute : "" + intMinute;
        return strReturn;
    }

    public static String getSecond() {
        String strReturn = "";
        int intSecond = Calendar.getInstance().get(13);
        strReturn = intSecond < 10 ? "0" + intSecond : "" + intSecond;
        return strReturn;
    }

    public static String[] split(String strIn, String strDelimiters) throws Exception {
        int theIndex = 0;
        String[] arrReturn = null;
        String strErrorMessage = "";
        int intCount = 0;
        if (strIn.equals("") || strIn == null || strDelimiters.equals("") || strDelimiters == null) {
            strErrorMessage = "Str.split('" + strIn + "','" + strDelimiters + "'): \u5f85\u62c6\u5206\u5b57\u7b26\u4e32\u548c\u5206\u9694\u7b26\u4e32\u90fd\u4e0d\u80fd\u4e3a\u7a7a";
            throw new Exception(strErrorMessage);
        }
        if (strIn.length() < strDelimiters.length()) {
            strErrorMessage = "Str.split('" + strIn + "','" + strDelimiters + "'): \u5f85\u62c6\u5206\u5b57\u7b26\u4e32\u6bd4\u5206\u9694\u7b26\u4e32\u8fd8\u8981\u77ed";
            throw new Exception(strErrorMessage);
        }
        for (String strTemp = strIn; strTemp != "" && strTemp != null && (theIndex = strTemp.indexOf(strDelimiters)) != -1; strTemp = strTemp.substring(theIndex + strDelimiters.length())) {
            ++intCount;
        }
        arrReturn = new String[++intCount];
        for (int i = 0; i < intCount - 1; ++i) {
            theIndex = strIn.indexOf(strDelimiters);
            arrReturn[i] = strIn.substring(0, theIndex);
            strIn = strIn.substring(theIndex + strDelimiters.length());
        }
        arrReturn[intCount - 1] = strIn;
        return arrReturn;
    }

    public static String rightTrim(String strIn) {
        String strReturn = "";
        int intLength = 0;
        if (strIn == null || strIn.equals("") || strIn.equals("null")) {
            return "";
        }
        intLength = strIn.length();
        while (intLength > 0 && strIn.substring(intLength - 1, intLength).equals(" ")) {
            strIn = strIn.substring(0, intLength - 1);
            intLength = strIn.length();
        }
        strReturn = strIn;
        return strReturn;
    }

    public static double round(double v, int scale) {
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String string2Ascii(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i != chars.length - 1) {
                sbu.append((int)chars[i]).append("");
                continue;
            }
            sbu.append((int)chars[i]);
        }
        return sbu.toString().trim();
    }

    public static String asciiToString(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer sbu = new StringBuffer();
        String[] chars = value.split(",");
        for (int i = 0; i < chars.length; ++i) {
            sbu.append((char)Integer.parseInt(chars[i]));
        }
        return sbu.toString();
    }

    public static String toHexString(String s) {
        String str = "";
        if (s == null) {
            return "";
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            str = str + s4;
        }
        return str;
    }

    public static int string2AsciiSum(String value) {
        if (value == null) {
            return 0;
        }
        StringBuffer sbu = new StringBuffer();
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i != chars.length - 1) {
                sbu.append((int)chars[i]).append(",");
                continue;
            }
            sbu.append((int)chars[i]);
        }
        String[] tmp = sbu.toString().trim().split(",");
        int sum = 0;
        for (int i = 0; i < tmp.length; ++i) {
            sum += Integer.parseInt(tmp[i]);
        }
        return sum;
    }

    public static List<String> splitByRegex(String value, String regex) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (value == null) {
            return arrayList;
        }
        String[] result = value.split(regex);
        for (int i = 0; i < result.length; ++i) {
            String string = result[i];
            if (string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List<String> splitByComma(String value) {
        return StringUtils.splitByRegex(value, ",");
    }

    public static List<String> splitBySharp(String value) {
        return StringUtils.splitByRegex(value, "#");
    }

    public static String userNameReplaceWithStar(String userName) {
        int nameLength;
        String userNameAfterReplaced = "";
        if (userName == null) {
            userName = "";
        }
        if ((nameLength = userName.length()) <= 1) {
            userNameAfterReplaced = "*";
        } else if (nameLength == 2) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{0})\\d(?=\\d{1})", "");
        } else if (nameLength >= 3 && nameLength <= 6) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{1})\\d(?=\\d{1})", "");
        } else if (nameLength == 7) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{1})\\d(?=\\d{2})", "");
        } else if (nameLength == 8) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{2})\\d(?=\\d{2})", "");
        } else if (nameLength == 9) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{2})\\d(?=\\d{3})", "");
        } else if (nameLength == 10) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{3})\\d(?=\\d{3})", "");
        } else if (nameLength >= 11) {
            userNameAfterReplaced = StringUtils.replaceAction(userName, "(?<=\\d{3})\\d(?=\\d{4})", "");
        }
        return userNameAfterReplaced;
    }

    private static String replaceAction(String realStr, String regular, String replaceStr) {
        if (Lang.isEmpty(replaceStr)) {
            replaceStr = "*";
        }
        log.info("\u66ff\u6362\u7ed3\u679c\uff1a" + realStr.replaceAll(regular, replaceStr));
        return realStr.replaceAll(regular, replaceStr);
    }

    public static String idCardReplaceWithStar(String idCard) {
        if (Lang.isEmpty(idCard)) {
            return null;
        }
        return StringUtils.replaceAction(idCard, "(?<=\\d{4})\\d(?=\\d{4})", "*");
    }

    public static String bankCardReplaceWithStar(String bankCard) {
        if (Lang.isEmpty(bankCard)) {
            return null;
        }
        return StringUtils.replaceAction(bankCard, "(?<=\\d{0})\\d(?=\\d{4})", "*");
    }

    public static String stringReplace(String replaceStr, int leftKeepDigits, int rightKeepDigits, String wantReplace) {
        String regular = "(?<=\\w{" + leftKeepDigits + "})\\w(?=\\w{" + rightKeepDigits + "})";
        log.info("\u66ff\u6362\u7684\u6b63\u5219\uff1a" + regular);
        int strLength = replaceStr.length();
        int sumKeepDigits = leftKeepDigits + rightKeepDigits;
        if (strLength <= sumKeepDigits) {
            return replaceStr;
        }
        if (Lang.isEmpty(replaceStr)) {
            return null;
        }
        return StringUtils.replaceAction(replaceStr, regular, wantReplace);
    }
}

