/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlog4j;

import com.github.structlog4j.IFormatter;
import com.github.structlog4j.IToLog;
import com.github.structlog4j.KeyValuePairFormatter;
import java.util.Optional;
import java.util.function.Function;

public final class StructLog4J {
    static final String VALUE_NULL = "null";
    private static IFormatter formatter = KeyValuePairFormatter.getInstance();
    private static Optional<IToLog> mandatoryContextSupplier = Optional.empty();
    private static Function<Object, String> defaultValueFormatter = value -> value == null ? VALUE_NULL : value.toString();
    private static Function<Object, String> valueFormatter = defaultValueFormatter;

    public static void setFormatter(IFormatter formatter) {
        StructLog4J.formatter = formatter;
    }

    public static void setMandatoryContextSupplier(IToLog mandatoryContextSupplier) {
        StructLog4J.mandatoryContextSupplier = Optional.of(mandatoryContextSupplier);
    }

    public static void setValueFormatter(Function<Object, String> formatter) {
        if (formatter == null) {
            throw new RuntimeException("Value formatter cannot be null");
        }
        valueFormatter = formatter;
    }

    public static IFormatter getFormatter() {
        return formatter;
    }

    public static Optional<IToLog> getMandatoryContextSupplier() {
        return mandatoryContextSupplier;
    }

    public static void clearMandatoryContextSupplier() {
        mandatoryContextSupplier = Optional.empty();
    }

    public static Function<Object, String> getValueFormatter() {
        return valueFormatter;
    }

    public static boolean isPrimitiveOrNumber(Class<?> valueType) {
        return valueType.isPrimitive() || Boolean.class.equals(valueType) || Short.class.equals(valueType) || Integer.class.equals(valueType) || Long.class.equals(valueType) || Double.class.equals(valueType) || Float.class.equals(valueType);
    }

    private StructLog4J() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

