/*
 * Decompiled with CFR 0.152.
 */
package com.github.structlog4j.json;

import com.github.structlog4j.IFormatter;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.slf4j.Logger;

public class JsonFormatter
implements IFormatter<JsonObjectBuilder> {
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_MESSAGE_2 = "message2";
    private static final JsonFormatter INSTANCE = new JsonFormatter();

    public static JsonFormatter getInstance() {
        return INSTANCE;
    }

    public final JsonObjectBuilder start(Logger log) {
        return Json.createObjectBuilder();
    }

    public final IFormatter<JsonObjectBuilder> addMessage(Logger log, JsonObjectBuilder bld, String message) {
        bld.add(FIELD_MESSAGE, message);
        return this;
    }

    public final IFormatter<JsonObjectBuilder> addKeyValue(Logger log, JsonObjectBuilder bld, String key, Object value) {
        if (key.equals(FIELD_MESSAGE)) {
            key = FIELD_MESSAGE_2;
            log.warn("Key 'message' renamed to 'message2' in order to avoid overriding default JSON message field. Please correct in your code.");
        }
        if (value == null) {
            bld.addNull(key);
        } else if (value instanceof Boolean) {
            bld.add(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer || value instanceof Short) {
            bld.add(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            bld.add(key, ((Long)value).longValue());
        } else if (value instanceof Double || value instanceof Float) {
            bld.add(key, ((Double)value).doubleValue());
        } else {
            bld.add(key, String.valueOf(value));
        }
        return this;
    }

    public final String end(Logger log, JsonObjectBuilder bld) {
        StringWriter stWriter = new StringWriter();
        try (JsonWriter jsonWriter = Json.createWriter((Writer)stWriter);){
            jsonWriter.writeObject(bld.build());
        }
        return stWriter.toString();
    }
}

