/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.sms.net.rmi;

import com.cntaiping.sms.net.rmi.ISmsService;
import com.cntaiping.sms.net.rmi.TPSmsMessages;
import com.cntaiping.sms.net.utils.ConfigUtils;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Date;
import java.util.List;

public class SmsClientService {
    private static String host = ConfigUtils.getString("host");
    private static int port = ConfigUtils.getInt("port");
    private static String username = ConfigUtils.getString("username");
    private static String password = ConfigUtils.getString("password");

    private static ISmsService getSmsService() throws Exception {
        try {
            Registry registry = LocateRegistry.getRegistry(host, port);
            ISmsService smmService = (ISmsService)registry.lookup("smsService");
            return smmService;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6\u8fdc\u7a0b\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ed1\u5b9a\u8fdc\u7a0b\u5bf9\u8c61", e);
        }
    }

    public static String sendSMS(TPSmsMessages msg) throws Exception {
        if (username != null && password != null) {
            return SmsClientService.getSmsService().sendSMS(username, password, msg);
        }
        return SmsClientService.getSmsService().sendSMS(msg.getUsername(), msg.getPassword(), msg);
    }

    public static List getSmsList(String phone, Date beginDate, Date endDate) throws Exception {
        return SmsClientService.getSmsService().getSmsList(phone, beginDate, endDate);
    }
}

