/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    private static final int RND_PORT_START = 30000;
    private static final int RND_PORT_END = 65535;
    private static volatile String HOST_ADDRESS;
    private static final String LOCALHOST_VALUE = "127.0.0.1";
    private static volatile InetAddress LOCAL_ADDRESS;
    private static final Pattern IP_PATTERN;
    private static final String ANY_HOST_VALUE = "0.0.0.0";

    private NetUtils() {
    }

    public static int getRandomPort() {
        return ThreadLocalRandom.current().nextInt(30000, 65535);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIpPortAvailable(String ip, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(ip, port), 1000);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getLocalHost() {
        if (HOST_ADDRESS != null) {
            return HOST_ADDRESS;
        }
        String addressFromJVM = System.getProperty("powerjob.network.local.address");
        if (StringUtils.isNotEmpty((CharSequence)addressFromJVM)) {
            log.info("[Net] use address from[{}]: {}", (Object)"powerjob.network.local.address", (Object)addressFromJVM);
            HOST_ADDRESS = addressFromJVM;
            return HOST_ADDRESS;
        }
        InetAddress address = NetUtils.getLocalAddress();
        if (address != null) {
            HOST_ADDRESS = address.getHostAddress();
            return HOST_ADDRESS;
        }
        return LOCALHOST_VALUE;
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        try {
            InetAddress addressOp = NetUtils.getFirstReachableInetAddress(NetUtils.findNetworkInterface());
            if (addressOp != null) {
                return addressOp;
            }
        }
        catch (Throwable e) {
            log.warn("[Net] getLocalAddress0 failed.", e);
        }
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable e) {
            log.warn("[Net] getLocalAddress0 failed.", e);
        }
        return localAddress;
    }

    private static InetAddress getFirstReachableInetAddress(NetworkInterface networkInterface) {
        if (networkInterface == null) {
            return null;
        }
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
            if (!addressOp.isPresent()) continue;
            try {
                if (!addressOp.get().isReachable(100)) continue;
                return addressOp.get();
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static NetworkInterface findNetworkInterface() {
        List<Object> validNetworkInterfaces = Collections.emptyList();
        try {
            validNetworkInterfaces = NetUtils.getValidNetworkInterfaces();
        }
        catch (Throwable e) {
            log.warn("[Net] findNetworkInterface failed", e);
        }
        validNetworkInterfaces.sort(Comparator.comparingInt(NetworkInterface::getIndex));
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            if (!NetUtils.isPreferredNetworkInterface(networkInterface)) continue;
            log.info("[Net] use preferred network interface: {}", (Object)networkInterface.getDisplayName());
            return networkInterface;
        }
        for (NetworkInterface networkInterface : validNetworkInterfaces) {
            InetAddress addressOp = NetUtils.getFirstReachableInetAddress(networkInterface);
            if (addressOp == null) continue;
            return networkInterface;
        }
        return (NetworkInterface)NetUtils.first(validNetworkInterfaces);
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (address instanceof Inet6Address) {
            Inet6Address v6Address = (Inet6Address)address;
            if (NetUtils.isPreferIPV6Address()) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
        }
        if (NetUtils.isValidV4Address(address)) {
            return Optional.of(address);
        }
        return Optional.empty();
    }

    static boolean isPreferIPV6Address() {
        return Boolean.getBoolean("java.net.preferIPv6Addresses");
    }

    static boolean isValidV4Address(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANY_HOST_VALUE.equals(name) && !LOCALHOST_VALUE.equals(name);
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    private static List<NetworkInterface> getValidNetworkInterfaces() throws SocketException {
        LinkedList<NetworkInterface> validNetworkInterfaces = new LinkedList<NetworkInterface>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (NetUtils.ignoreNetworkInterface(networkInterface) || NetUtils.ignoreInterfaceByConfig(networkInterface.getDisplayName()) || NetUtils.ignoreInterfaceByConfig(networkInterface.getName())) continue;
            validNetworkInterfaces.add(networkInterface);
        }
        return validNetworkInterfaces;
    }

    private static boolean ignoreNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        return networkInterface == null || networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp();
    }

    public static <T> T first(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            return (T)list.get(0);
        }
        return values.iterator().next();
    }

    public static boolean isPreferredNetworkInterface(NetworkInterface networkInterface) {
        String preferredNetworkInterface = System.getProperty("powerjob.network.interface.preferred");
        if (Objects.equals(networkInterface.getDisplayName(), preferredNetworkInterface)) {
            return true;
        }
        return Objects.equals(networkInterface.getName(), preferredNetworkInterface);
    }

    public static Pair<String, Integer> splitAddress2IpAndPort(String address) {
        String[] split = address.split(":");
        return Pair.of((Object)split[0], (Object)Integer.valueOf(split[1]));
    }

    static boolean ignoreInterfaceByConfig(String interfaceName) {
        String regex = System.getProperty("powerjob.network.interface.ignored");
        if (StringUtils.isBlank((CharSequence)regex)) {
            return false;
        }
        if (interfaceName.matches(regex)) {
            log.info("[Net] ignore network interface: {} by regex({})", (Object)interfaceName, (Object)regex);
            return true;
        }
        return false;
    }

    static {
        LOCAL_ADDRESS = null;
        IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    }
}

