/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.powerjob.com.google.common.base.Stopwatch;
import shade.powerjob.org.apache.commons.lang3.exception.ExceptionUtils;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.official.processors.util.SecurityUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;
import tech.powerjob.worker.log.OmsLogger;

public abstract class CommonBasicProcessor
implements BasicProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommonBasicProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult process(TaskContext ctx) throws Exception {
        ProcessResult processResult;
        OmsLogger omsLogger = ctx.getOmsLogger();
        String securityDKey = this.getSecurityDKey();
        if (SecurityUtils.disable(securityDKey)) {
            String msg = String.format("%s is not enabled, please set '-D%s=true' to enable it", this.getClass().getSimpleName(), securityDKey);
            omsLogger.warn(msg, new Object[0]);
            return new ProcessResult(false, msg);
        }
        String status = "unknown";
        Stopwatch sw = Stopwatch.createStarted();
        omsLogger.info("using params: {}", new Object[]{CommonUtils.parseParams(ctx)});
        try {
            ProcessResult result = this.process0(ctx);
            omsLogger.info("execute succeed, using {}, result: {}", new Object[]{sw, result});
            status = result.isSuccess() ? "succeed" : "failed";
            processResult = result;
        }
        catch (Throwable t) {
            ProcessResult processResult2;
            try {
                status = "exception";
                omsLogger.error("execute failed!", new Object[]{t});
                processResult2 = new ProcessResult(false, ExceptionUtils.getMessage(t));
            }
            catch (Throwable throwable) {
                log.info("{}|{}|{}|{}|{}", new Object[]{this.getClass().getSimpleName(), ctx.getJobId(), ctx.getInstanceId(), status, sw});
                throw throwable;
            }
            log.info("{}|{}|{}|{}|{}", new Object[]{this.getClass().getSimpleName(), ctx.getJobId(), ctx.getInstanceId(), status, sw});
            return processResult2;
        }
        log.info("{}|{}|{}|{}|{}", new Object[]{this.getClass().getSimpleName(), ctx.getJobId(), ctx.getInstanceId(), status, sw});
        return processResult;
    }

    protected abstract ProcessResult process0(TaskContext var1) throws Exception;

    protected String getSecurityDKey() {
        return null;
    }
}

