/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.official.processors.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.powerjob.com.alibaba.fastjson.JSONObject;
import shade.powerjob.com.google.common.collect.Maps;
import shade.powerjob.org.apache.commons.io.FileUtils;
import shade.powerjob.org.apache.commons.lang3.StringUtils;
import tech.powerjob.common.serialize.JsonUtils;
import tech.powerjob.official.processors.util.CommonUtils;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BroadcastProcessor;

public class ConfigProcessor
implements BroadcastProcessor {
    private static final Logger log = LoggerFactory.getLogger(ConfigProcessor.class);
    private static Config config;

    public static Map<String, Object> fetchConfig() {
        if (config == null) {
            return Maps.newHashMap();
        }
        return Optional.ofNullable(config.getConfig()).orElse(Maps.newHashMap());
    }

    public ProcessResult process(TaskContext context) throws Exception {
        Config newCfg = (Config)JsonUtils.parseObject((String)CommonUtils.parseParams(context), Config.class);
        context.getOmsLogger().info("[ConfigProcessor] receive and update config: {}", new Object[]{config});
        Map realConfig = newCfg.config;
        if (realConfig == null) {
            return new ProcessResult(false, "CONFIG_IS_NULL");
        }
        config = newCfg;
        if (StringUtils.isNotEmpty(config.persistentFileName)) {
            File file = new File(config.persistentFileName);
            String content = JSONObject.toJSONString(realConfig);
            FileUtils.copyToFile(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), file);
        }
        return new ProcessResult(true, "UPDATE_SUCCESS");
    }

    public static class Config
    implements Serializable {
        private Map<String, Object> config;
        private String persistentFileName;

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public String getPersistentFileName() {
            return this.persistentFileName;
        }

        public void setConfig(Map<String, Object> config) {
            this.config = config;
        }

        public void setPersistentFileName(String persistentFileName) {
            this.persistentFileName = persistentFileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$config = this.getConfig();
            Map<String, Object> other$config = other.getConfig();
            if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
                return false;
            }
            String this$persistentFileName = this.getPersistentFileName();
            String other$persistentFileName = other.getPersistentFileName();
            return !(this$persistentFileName == null ? other$persistentFileName != null : !this$persistentFileName.equals(other$persistentFileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            String $persistentFileName = this.getPersistentFileName();
            result = result * 59 + ($persistentFileName == null ? 43 : $persistentFileName.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigProcessor.Config(config=" + this.getConfig() + ", persistentFileName=" + this.getPersistentFileName() + ")";
        }
    }
}

