/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.remote.akka;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import akka.japi.pf.ReceiveBuilder;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.remote.framework.actor.ActorInfo;
import tech.powerjob.remote.framework.actor.HandlerInfo;
import tech.powerjob.remote.framework.base.HandlerLocation;
import tech.powerjob.remote.framework.utils.RemoteUtils;

public class AkkaProxyActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(AkkaProxyActor.class);
    private final AbstractActor.Receive receive;
    private final ActorInfo actorInfo;

    public static Props props(ActorInfo actorInfo) {
        return Props.create(AkkaProxyActor.class, (Creator & Serializable)() -> new AkkaProxyActor(actorInfo));
    }

    public AkkaProxyActor(ActorInfo actorInfo) {
        this.actorInfo = actorInfo;
        ReceiveBuilder receiveBuilder = this.receiveBuilder();
        actorInfo.getHandlerInfos().forEach(handlerInfo -> {
            HandlerLocation location = handlerInfo.getLocation();
            Method handlerMethod = handlerInfo.getMethod();
            Optional powerSerializeClz = RemoteUtils.findPowerSerialize((Class[])handlerMethod.getParameterTypes());
            if (!powerSerializeClz.isPresent()) {
                throw new PowerJobException("build proxy for handler failed due to handler args is not PowerSerialize: " + location);
            }
            Class bindClz = (Class)powerSerializeClz.get();
            receiveBuilder.match(bindClz, req -> this.onReceiveProcessorReportTaskStatusReq((Object)req, (HandlerInfo)handlerInfo));
        });
        this.receive = receiveBuilder.build();
    }

    public AbstractActor.Receive createReceive() {
        return this.receive;
    }

    private <T> void onReceiveProcessorReportTaskStatusReq(T req, HandlerInfo handlerInfo) {
        try {
            Object ret = handlerInfo.getMethod().invoke(this.actorInfo.getActor(), req);
            if (ret == null) {
                return;
            }
            if (ret instanceof Optional && !((Optional)ret).isPresent()) {
                return;
            }
            this.getSender().tell(ret, this.getSelf());
        }
        catch (Exception e) {
            log.error("[PowerJob-AKKA] process failed!", (Throwable)e);
        }
    }
}

