/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.common.module;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.model.DeployedContainerInfo;
import tech.powerjob.common.model.SystemMetrics;
import tech.powerjob.common.request.WorkerHeartbeat;

public class WorkerInfo {
    private static final Logger log = LoggerFactory.getLogger(WorkerInfo.class);
    private String address;
    private long lastActiveTime;
    private String protocol;
    private String client;
    private String tag;
    private int lightTaskTrackerNum;
    private int heavyTaskTrackerNum;
    private long lastOverloadTime;
    private boolean overloading;
    private SystemMetrics systemMetrics;
    private List<DeployedContainerInfo> containerInfos;
    private static final long WORKER_TIMEOUT_MS = 60000L;

    public void refresh(WorkerHeartbeat workerHeartbeat) {
        this.address = workerHeartbeat.getWorkerAddress();
        this.lastActiveTime = workerHeartbeat.getHeartbeatTime();
        this.protocol = workerHeartbeat.getProtocol();
        this.client = workerHeartbeat.getClient();
        this.tag = workerHeartbeat.getTag();
        this.systemMetrics = workerHeartbeat.getSystemMetrics();
        this.containerInfos = workerHeartbeat.getContainerInfos();
        this.lightTaskTrackerNum = workerHeartbeat.getLightTaskTrackerNum();
        this.heavyTaskTrackerNum = workerHeartbeat.getHeavyTaskTrackerNum();
        if (workerHeartbeat.isOverload()) {
            this.overloading = true;
            this.lastOverloadTime = workerHeartbeat.getHeartbeatTime();
            log.warn("[WorkerInfo] worker {} is overload!", (Object)this.getAddress());
        } else {
            this.overloading = false;
        }
    }

    public boolean timeout() {
        long timeout = System.currentTimeMillis() - this.lastActiveTime;
        return timeout > 60000L;
    }

    public boolean overload() {
        return this.overloading;
    }

    public String getAddress() {
        return this.address;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getClient() {
        return this.client;
    }

    public String getTag() {
        return this.tag;
    }

    public int getLightTaskTrackerNum() {
        return this.lightTaskTrackerNum;
    }

    public int getHeavyTaskTrackerNum() {
        return this.heavyTaskTrackerNum;
    }

    public long getLastOverloadTime() {
        return this.lastOverloadTime;
    }

    public boolean isOverloading() {
        return this.overloading;
    }

    public SystemMetrics getSystemMetrics() {
        return this.systemMetrics;
    }

    public List<DeployedContainerInfo> getContainerInfos() {
        return this.containerInfos;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setLightTaskTrackerNum(int lightTaskTrackerNum) {
        this.lightTaskTrackerNum = lightTaskTrackerNum;
    }

    public void setHeavyTaskTrackerNum(int heavyTaskTrackerNum) {
        this.heavyTaskTrackerNum = heavyTaskTrackerNum;
    }

    public void setLastOverloadTime(long lastOverloadTime) {
        this.lastOverloadTime = lastOverloadTime;
    }

    public void setOverloading(boolean overloading) {
        this.overloading = overloading;
    }

    public void setSystemMetrics(SystemMetrics systemMetrics) {
        this.systemMetrics = systemMetrics;
    }

    public void setContainerInfos(List<DeployedContainerInfo> containerInfos) {
        this.containerInfos = containerInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerInfo)) {
            return false;
        }
        WorkerInfo other = (WorkerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        if (this.getLastActiveTime() != other.getLastActiveTime()) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$client = this.getClient();
        String other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        if (this.getLightTaskTrackerNum() != other.getLightTaskTrackerNum()) {
            return false;
        }
        if (this.getHeavyTaskTrackerNum() != other.getHeavyTaskTrackerNum()) {
            return false;
        }
        if (this.getLastOverloadTime() != other.getLastOverloadTime()) {
            return false;
        }
        if (this.isOverloading() != other.isOverloading()) {
            return false;
        }
        SystemMetrics this$systemMetrics = this.getSystemMetrics();
        SystemMetrics other$systemMetrics = other.getSystemMetrics();
        if (this$systemMetrics == null ? other$systemMetrics != null : !this$systemMetrics.equals(other$systemMetrics)) {
            return false;
        }
        List<DeployedContainerInfo> this$containerInfos = this.getContainerInfos();
        List<DeployedContainerInfo> other$containerInfos = other.getContainerInfos();
        return !(this$containerInfos == null ? other$containerInfos != null : !((Object)this$containerInfos).equals(other$containerInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        long $lastActiveTime = this.getLastActiveTime();
        result = result * 59 + (int)($lastActiveTime >>> 32 ^ $lastActiveTime);
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        result = result * 59 + this.getLightTaskTrackerNum();
        result = result * 59 + this.getHeavyTaskTrackerNum();
        long $lastOverloadTime = this.getLastOverloadTime();
        result = result * 59 + (int)($lastOverloadTime >>> 32 ^ $lastOverloadTime);
        result = result * 59 + (this.isOverloading() ? 79 : 97);
        SystemMetrics $systemMetrics = this.getSystemMetrics();
        result = result * 59 + ($systemMetrics == null ? 43 : $systemMetrics.hashCode());
        List<DeployedContainerInfo> $containerInfos = this.getContainerInfos();
        result = result * 59 + ($containerInfos == null ? 43 : ((Object)$containerInfos).hashCode());
        return result;
    }

    public String toString() {
        return "WorkerInfo(address=" + this.getAddress() + ", lastActiveTime=" + this.getLastActiveTime() + ", protocol=" + this.getProtocol() + ", client=" + this.getClient() + ", tag=" + this.getTag() + ", lightTaskTrackerNum=" + this.getLightTaskTrackerNum() + ", heavyTaskTrackerNum=" + this.getHeavyTaskTrackerNum() + ", lastOverloadTime=" + this.getLastOverloadTime() + ", overloading=" + this.isOverloading() + ", systemMetrics=" + this.getSystemMetrics() + ", containerInfos=" + this.getContainerInfos() + ")";
    }
}

