/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.service;

import com.alibaba.fastjson.JSON;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.server.core.workflow.hanlder.ControlNodeHandler;
import tech.powerjob.server.core.workflow.hanlder.TaskNodeHandler;
import tech.powerjob.server.core.workflow.hanlder.WorkflowNodeHandlerMarker;
import tech.powerjob.server.persistence.remote.model.WorkflowInstanceInfoDO;
import tech.powerjob.server.persistence.remote.repository.WorkflowInstanceInfoRepository;

@Service
public class WorkflowNodeHandleService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowNodeHandleService.class);
    private final Map<WorkflowNodeType, ControlNodeHandler> controlNodeHandlerContainer = new EnumMap<WorkflowNodeType, ControlNodeHandler>(WorkflowNodeType.class);
    private final Map<WorkflowNodeType, TaskNodeHandler> taskNodeHandlerContainer = new EnumMap<WorkflowNodeType, TaskNodeHandler>(WorkflowNodeType.class);
    private final WorkflowInstanceInfoRepository workflowInstanceInfoRepository;

    public WorkflowNodeHandleService(List<ControlNodeHandler> controlNodeHandlerList, List<TaskNodeHandler> taskNodeHandlerList, WorkflowInstanceInfoRepository workflowInstanceInfoRepository) {
        controlNodeHandlerList.forEach(controlNodeHandler -> this.controlNodeHandlerContainer.put(controlNodeHandler.matchingType(), (ControlNodeHandler)controlNodeHandler));
        taskNodeHandlerList.forEach(taskNodeHandler -> this.taskNodeHandlerContainer.put(taskNodeHandler.matchingType(), (TaskNodeHandler)taskNodeHandler));
        this.workflowInstanceInfoRepository = workflowInstanceInfoRepository;
    }

    public void handleTaskNodes(List<PEWorkflowDAG.Node> taskNodeList, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        taskNodeList.forEach(taskNode -> {
            TaskNodeHandler taskNodeHandler = (TaskNodeHandler)this.findMatchingHandler((PEWorkflowDAG.Node)taskNode);
            taskNodeHandler.createTaskInstance((PEWorkflowDAG.Node)taskNode, dag, wfInstanceInfo);
            log.debug("[Workflow-{}|{}] workflowInstance start to process new node(nodeId={},jobId={})", new Object[]{wfInstanceInfo.getWorkflowId(), wfInstanceInfo.getWfInstanceId(), taskNode.getNodeId(), taskNode.getJobId()});
        });
        wfInstanceInfo.setDag(JSON.toJSONString((Object)dag));
        this.workflowInstanceInfoRepository.saveAndFlush((Object)wfInstanceInfo);
        taskNodeList.forEach(taskNode -> {
            TaskNodeHandler taskNodeHandler = (TaskNodeHandler)this.findMatchingHandler((PEWorkflowDAG.Node)taskNode);
            taskNodeHandler.startTaskInstance((PEWorkflowDAG.Node)taskNode);
        });
    }

    public void handleControlNodes(List<PEWorkflowDAG.Node> controlNodeList, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        for (PEWorkflowDAG.Node node : controlNodeList) {
            this.handleControlNode(node, dag, wfInstanceInfo);
        }
    }

    public void handleControlNode(PEWorkflowDAG.Node node, PEWorkflowDAG dag, WorkflowInstanceInfoDO wfInstanceInfo) {
        ControlNodeHandler controlNodeHandler = (ControlNodeHandler)this.findMatchingHandler(node);
        node.setStartTime(CommonUtils.formatTime((Long)System.currentTimeMillis()));
        controlNodeHandler.handle(node, dag, wfInstanceInfo);
        node.setFinishedTime(CommonUtils.formatTime((Long)System.currentTimeMillis()));
    }

    private WorkflowNodeHandlerMarker findMatchingHandler(PEWorkflowDAG.Node node) {
        WorkflowNodeType nodeType = WorkflowNodeType.of((int)node.getNodeType());
        WorkflowNodeHandlerMarker res = !nodeType.isControlNode() ? (WorkflowNodeHandlerMarker)this.taskNodeHandlerContainer.get(nodeType) : (WorkflowNodeHandlerMarker)this.controlNodeHandlerContainer.get(nodeType);
        if (res == null) {
            throw new UnsupportedOperationException("unsupported node type : " + nodeType);
        }
        return res;
    }
}

