/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.workflow.algorithm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import tech.powerjob.common.model.PEWorkflowDAG;

public class WorkflowDAG {
    private List<Node> roots;
    private Map<Long, Node> nodeMap;

    public Node getNode(Long nodeId) {
        if (this.nodeMap == null) {
            return null;
        }
        return this.nodeMap.get(nodeId);
    }

    public List<Node> getRoots() {
        return this.roots;
    }

    public Map<Long, Node> getNodeMap() {
        return this.nodeMap;
    }

    public void setRoots(List<Node> roots) {
        this.roots = roots;
    }

    public void setNodeMap(Map<Long, Node> nodeMap) {
        this.nodeMap = nodeMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowDAG)) {
            return false;
        }
        WorkflowDAG other = (WorkflowDAG)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Node> this$roots = this.getRoots();
        List<Node> other$roots = other.getRoots();
        if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
            return false;
        }
        Map<Long, Node> this$nodeMap = this.getNodeMap();
        Map<Long, Node> other$nodeMap = other.getNodeMap();
        return !(this$nodeMap == null ? other$nodeMap != null : !((Object)this$nodeMap).equals(other$nodeMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkflowDAG;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Node> $roots = this.getRoots();
        result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
        Map<Long, Node> $nodeMap = this.getNodeMap();
        result = result * 59 + ($nodeMap == null ? 43 : ((Object)$nodeMap).hashCode());
        return result;
    }

    public String toString() {
        return "WorkflowDAG(roots=" + this.getRoots() + ")";
    }

    public WorkflowDAG() {
    }

    public WorkflowDAG(List<Node> roots, Map<Long, Node> nodeMap) {
        this.roots = roots;
        this.nodeMap = nodeMap;
    }

    public static final class Node {
        private Long nodeId;
        private PEWorkflowDAG.Node holder;
        private List<Node> dependencies;
        private Map<Node, PEWorkflowDAG.Edge> dependenceEdgeMap;
        private List<Node> successors;
        private Map<Node, PEWorkflowDAG.Edge> successorEdgeMap;

        public Node(PEWorkflowDAG.Node node) {
            this.nodeId = node.getNodeId();
            this.holder = node;
            this.dependencies = Lists.newLinkedList();
            this.dependenceEdgeMap = Maps.newHashMap();
            this.successors = Lists.newLinkedList();
            this.successorEdgeMap = Maps.newHashMap();
        }

        public Long getNodeId() {
            return this.nodeId;
        }

        public PEWorkflowDAG.Node getHolder() {
            return this.holder;
        }

        public List<Node> getDependencies() {
            return this.dependencies;
        }

        public Map<Node, PEWorkflowDAG.Edge> getDependenceEdgeMap() {
            return this.dependenceEdgeMap;
        }

        public List<Node> getSuccessors() {
            return this.successors;
        }

        public Map<Node, PEWorkflowDAG.Edge> getSuccessorEdgeMap() {
            return this.successorEdgeMap;
        }

        public void setNodeId(Long nodeId) {
            this.nodeId = nodeId;
        }

        public void setHolder(PEWorkflowDAG.Node holder) {
            this.holder = holder;
        }

        public void setDependencies(List<Node> dependencies) {
            this.dependencies = dependencies;
        }

        public void setDependenceEdgeMap(Map<Node, PEWorkflowDAG.Edge> dependenceEdgeMap) {
            this.dependenceEdgeMap = dependenceEdgeMap;
        }

        public void setSuccessors(List<Node> successors) {
            this.successors = successors;
        }

        public void setSuccessorEdgeMap(Map<Node, PEWorkflowDAG.Edge> successorEdgeMap) {
            this.successorEdgeMap = successorEdgeMap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            Long this$nodeId = this.getNodeId();
            Long other$nodeId = other.getNodeId();
            return !(this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $nodeId = this.getNodeId();
            result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
            return result;
        }

        public String toString() {
            return "WorkflowDAG.Node(nodeId=" + this.getNodeId() + ", successors=" + this.getSuccessors() + ")";
        }

        public Node() {
        }
    }
}

