/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.remote.repository;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.brief.BriefInstanceInfo;

public interface InstanceInfoRepository
extends JpaRepository<InstanceInfoDO, Long>,
JpaSpecificationExecutor<InstanceInfoDO> {
    @Query(value="select count(*) from InstanceInfoDO where jobId = ?1 and status in ?2")
    public long countByJobIdAndStatusIn(long var1, List<Integer> var3);

    public List<InstanceInfoDO> findByJobIdAndStatusIn(long var1, List<Integer> var3);

    @Transactional(rollbackOn={Exception.class})
    @Modifying
    @Query(value="update InstanceInfoDO set lastReportTime = :lastReportTime, gmtModified = :modifyTime, runningTimes = :runningTimes, status = :status  where instanceId = :instanceId and status = :oldStatus")
    public int updateStatusChangeInfoByInstanceIdAndStatus(@Param(value="lastReportTime") long var1, @Param(value="modifyTime") Date var3, @Param(value="runningTimes") long var4, @Param(value="status") int var6, @Param(value="instanceId") long var7, @Param(value="oldStatus") int var9);

    @Transactional(rollbackOn={Exception.class})
    @Modifying
    @Query(value="update InstanceInfoDO set status = :status, actualTriggerTime = :actualTriggerTime, finishedTime = :finishedTime, taskTrackerAddress = :taskTrackerAddress, result = :result,  gmtModified = :modifyTime where instanceId = :instanceId")
    @CanIgnoreReturnValue
    public int update4TriggerFailed(@Param(value="instanceId") long var1, @Param(value="status") int var3, @Param(value="actualTriggerTime") long var4, @Param(value="finishedTime") long var6, @Param(value="taskTrackerAddress") String var8, @Param(value="result") String var9, @Param(value="modifyTime") Date var10);

    @Transactional(rollbackOn={Exception.class})
    @Modifying
    @Query(value="update InstanceInfoDO set status = :status,  actualTriggerTime = :actualTriggerTime, taskTrackerAddress = :taskTrackerAddress, gmtModified = :modifyTime where instanceId = :instanceId and status = :oldStatus")
    @CanIgnoreReturnValue
    public int update4TriggerSucceed(@Param(value="instanceId") long var1, @Param(value="status") int var3, @Param(value="actualTriggerTime") long var4, @Param(value="taskTrackerAddress") String var6, @Param(value="modifyTime") Date var7, @Param(value="oldStatus") int var8);

    @Transactional(rollbackOn={Exception.class})
    @Modifying
    @Query(value="update InstanceInfoDO set status = :status, gmtModified = :modifyTime where instanceId = :instanceId and status = :originStatus ")
    @CanIgnoreReturnValue
    public int updateStatusAndGmtModifiedByInstanceIdAndOriginStatus(@Param(value="instanceId") long var1, @Param(value="originStatus") int var3, @Param(value="status") int var4, @Param(value="modifyTime") Date var5);

    @Transactional(rollbackOn={Exception.class})
    @Modifying
    @Query(value="update InstanceInfoDO set status = :status, gmtModified = :modifyTime where instanceId in (:instanceIdList) and status = :originStatus ")
    @CanIgnoreReturnValue
    public int updateStatusAndGmtModifiedByInstanceIdListAndOriginStatus(@Param(value="instanceIdList") List<Long> var1, @Param(value="originStatus") int var2, @Param(value="status") int var3, @Param(value="modifyTime") Date var4);

    @Modifying
    @Transactional(rollbackOn={Exception.class})
    @Query(value="update InstanceInfoDO set status = :status, runningTimes = :runningTimes, gmtModified = :modifyTime where instanceId = :instanceId")
    @CanIgnoreReturnValue
    public int update4FrequentJob(@Param(value="instanceId") long var1, @Param(value="status") int var3, @Param(value="runningTimes") long var4, @Param(value="modifyTime") Date var6);

    public List<InstanceInfoDO> findAllByAppIdInAndStatusAndExpectedTriggerTimeLessThan(@Param(value="appIds") List<Long> var1, @Param(value="status") int var2, @Param(value="time") long var3, Pageable var5);

    @Query(value="select new tech.powerjob.server.persistence.remote.model.brief.BriefInstanceInfo(i.appId,i.id,i.jobId,i.instanceId) from InstanceInfoDO i where i.appId in (:appIds) and i.status = :status and i.actualTriggerTime < :time")
    public List<BriefInstanceInfo> selectBriefInfoByAppIdInAndStatusAndActualTriggerTimeLessThan(@Param(value="appIds") List<Long> var1, @Param(value="status") int var2, @Param(value="time") long var3, Pageable var5);

    @Query(value="select new tech.powerjob.server.persistence.remote.model.brief.BriefInstanceInfo(i.appId,i.id,i.jobId,i.instanceId,i.runningTimes) from InstanceInfoDO i where i.appId in (:appIds) and i.status = :status and i.gmtModified < :time")
    public List<BriefInstanceInfo> selectBriefInfoByAppIdInAndStatusAndGmtModifiedBefore(@Param(value="appIds") List<Long> var1, @Param(value="status") int var2, @Param(value="time") Date var3, Pageable var4);

    public InstanceInfoDO findByInstanceId(long var1);

    @Query(value="select count(*) from InstanceInfoDO where appId = ?1 and status = ?2")
    public long countByAppIdAndStatus(long var1, int var3);

    public long countByAppIdAndStatusAndGmtCreateAfter(long var1, int var3, Date var4);

    @Query(value="select distinct jobId from InstanceInfoDO where jobId in ?1 and status in ?2")
    public List<Long> findByJobIdInAndStatusIn(List<Long> var1, List<Integer> var2);

    @Modifying
    @Transactional(rollbackOn={Exception.class})
    @Query(value="delete from InstanceInfoDO where gmtModified < ?1 and status in ?2")
    public int deleteAllByGmtModifiedBeforeAndStatusIn(Date var1, List<Integer> var2);
}

