/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFF5)
@Conditional(value={GridFsCondition.class})
public class GridFsService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(GridFsService.class);
    private MongoClient mongoClient;
    private MongoDatabase db;
    private final Map<String, GridFSBucket> bucketCache = Maps.newConcurrentMap();
    private static final String TYPE_MONGO = "mongodb";
    private static final String KEY_URI = "uri";
    private static final String SPRING_MONGO_DB_CONFIG_KEY = "spring.data.mongodb.uri";

    public void store(StoreRequest storeRequest) throws IOException {
        GridFSBucket bucket = this.getBucket(storeRequest.getFileLocation().getBucket());
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(storeRequest.getLocalFile().toPath(), new OpenOption[0]));){
            bucket.uploadFromStream(storeRequest.getFileLocation().getName(), (InputStream)bis);
        }
    }

    public void download(DownloadRequest downloadRequest) throws IOException {
        GridFSBucket bucket = this.getBucket(downloadRequest.getFileLocation().getBucket());
        FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
        try (GridFSDownloadStream gis = bucket.openDownloadStream(downloadRequest.getFileLocation().getName());
             BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(downloadRequest.getTarget().toPath(), new OpenOption[0]));){
            byte[] buffer = new byte[1024];
            int bytes = 0;
            while ((bytes = gis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytes);
            }
            bos.flush();
        }
    }

    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) throws IOException {
        GridFSBucket bucket = this.getBucket(fileLocation.getBucket());
        GridFSFindIterable files = bucket.find(Filters.eq((String)"filename", (Object)fileLocation.getName()));
        GridFSFile first = (GridFSFile)files.first();
        if (first == null) {
            return Optional.empty();
        }
        return Optional.of(new FileMeta().setLength(first.getLength()).setLastModifiedTime(first.getUploadDate()).setMetaInfo((Map)first.getMetadata()));
    }

    public void cleanExpiredFiles(String bucketName, int days) {
        Stopwatch sw = Stopwatch.createStarted();
        Date date = DateUtils.addDays((Date)new Date(), (int)(-days));
        GridFSBucket bucket = this.getBucket(bucketName);
        Bson filter = Filters.lt((String)"uploadDate", (Object)date);
        bucket.find(filter).forEach(gridFSFile -> {
            ObjectId objectId = gridFSFile.getObjectId();
            try {
                bucket.delete(objectId);
                log.info("[GridFsService] deleted {}#{}", (Object)bucketName, (Object)objectId);
            }
            catch (Exception e) {
                log.error("[GridFsService] deleted {}#{} failed.", new Object[]{bucketName, objectId, e});
            }
        });
        log.info("[GridFsService] clean bucket({}) successfully, delete all files before {}, using {}.", new Object[]{bucketName, date, sw.stop()});
    }

    private GridFSBucket getBucket(String bucketName) {
        return this.bucketCache.computeIfAbsent(bucketName, ignore -> GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName));
    }

    private String parseMongoUri(Environment environment) {
        String uri = GridFsService.fetchProperty(environment, TYPE_MONGO, KEY_URI);
        if (StringUtils.isNotEmpty((CharSequence)uri)) {
            return uri;
        }
        return environment.getProperty(SPRING_MONGO_DB_CONFIG_KEY);
    }

    void initMongo(String uri) {
        log.info("[GridFsService] mongoDB uri: {}", (Object)uri);
        if (StringUtils.isEmpty((CharSequence)uri)) {
            log.warn("[GridFsService] uri is empty, GridFsService is off now!");
            return;
        }
        ConnectionString connectionString = new ConnectionString(uri);
        this.mongoClient = MongoClients.create((ConnectionString)connectionString);
        if (StringUtils.isEmpty((CharSequence)connectionString.getDatabase())) {
            log.warn("[GridFsService] can't find database info from uri, will use [powerjob] as default, please make sure you have created the database 'powerjob'");
        }
        this.db = this.mongoClient.getDatabase(Optional.ofNullable(connectionString.getDatabase()).orElse("powerjob"));
        log.info("[GridFsService] initialize MongoDB and GridFS successfully, will use mongodb GridFs as storage layer.");
    }

    public void destroy() throws Exception {
        this.mongoClient.close();
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        String uri = this.parseMongoUri(applicationContext.getEnvironment());
        this.initMongo(uri);
        log.info("[GridFsService] initialize successfully, THIS_WILL_BE_THE_STORAGE_LAYER.");
    }

    public static class GridFsCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{GridFsService.SPRING_MONGO_DB_CONFIG_KEY, "oms.storage.dfs.mongodb.uri"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }
}

