/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.persistence.storage.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.minio.BucketExistsArgs;
import io.minio.DownloadObjectArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.SetBucketPolicyArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import java.io.File;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Priority;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import tech.powerjob.server.common.spring.condition.PropertyAndOneBeanCondition;
import tech.powerjob.server.extension.dfs.DFsService;
import tech.powerjob.server.extension.dfs.DownloadRequest;
import tech.powerjob.server.extension.dfs.FileLocation;
import tech.powerjob.server.extension.dfs.FileMeta;
import tech.powerjob.server.extension.dfs.StoreRequest;
import tech.powerjob.server.persistence.storage.AbstractDFsService;

@Priority(value=0x7FFFFFFC)
@Conditional(value={MinioOssCondition.class})
public class MinioOssService
extends AbstractDFsService {
    private static final Logger log = LoggerFactory.getLogger(MinioOssService.class);
    private static final String TYPE_MINIO = "minio";
    private static final String KEY_ENDPOINT = "endpoint";
    private static final String KEY_BUCKET_NAME = "bucketName";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private MinioClient minioClient;
    private String bucket;
    private static final String NO_SUCH_KEY = "NoSuchKey";

    public void store(StoreRequest storeRequest) {
        try {
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(this.bucket)).object(MinioOssService.parseFileName(storeRequest.getFileLocation()))).filename(storeRequest.getLocalFile().getPath()).contentType(Files.probeContentType(storeRequest.getLocalFile().toPath())).build());
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public void download(DownloadRequest downloadRequest) {
        try {
            FileUtils.forceMkdirParent((File)downloadRequest.getTarget());
            this.minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(this.bucket)).object(MinioOssService.parseFileName(downloadRequest.getFileLocation()))).filename(downloadRequest.getTarget().getAbsolutePath()).build());
        }
        catch (Throwable t) {
            ExceptionUtils.rethrow((Throwable)t);
        }
    }

    public Optional<FileMeta> fetchFileMeta(FileLocation fileLocation) {
        try {
            StatObjectResponse stat = this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucket)).object(MinioOssService.parseFileName(fileLocation))).build());
            return Optional.ofNullable(stat).map(minioStat -> {
                HashMap metaInfo = Maps.newHashMap();
                if (stat.userMetadata() != null) {
                    metaInfo.putAll(stat.userMetadata());
                }
                return new FileMeta().setLastModifiedTime(Date.from(stat.lastModified().toInstant())).setLength(stat.size()).setMetaInfo((Map)metaInfo);
            });
        }
        catch (Exception oe) {
            String errorCode = oe.getMessage();
            if (NO_SUCH_KEY.equalsIgnoreCase(errorCode)) {
                return Optional.empty();
            }
            ExceptionUtils.rethrow((Throwable)oe);
            return Optional.empty();
        }
    }

    private static String parseFileName(FileLocation fileLocation) {
        return String.format("%s/%s", fileLocation.getBucket(), fileLocation.getName());
    }

    public void cleanExpiredFiles(String bucket, int days) {
    }

    public void destroy() {
    }

    @Override
    protected void init(ApplicationContext applicationContext) {
        Environment environment = applicationContext.getEnvironment();
        String endpoint = MinioOssService.fetchProperty(environment, TYPE_MINIO, KEY_ENDPOINT);
        String bucketName = MinioOssService.fetchProperty(environment, TYPE_MINIO, KEY_BUCKET_NAME);
        String accessKey = MinioOssService.fetchProperty(environment, TYPE_MINIO, ACCESS_KEY);
        String secretKey = MinioOssService.fetchProperty(environment, TYPE_MINIO, SECRET_KEY);
        try {
            this.initOssClient(endpoint, bucketName, accessKey, secretKey);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public void initOssClient(String endpoint, String bucketName, String accessKey, String secretKey) {
        log.info("[Minio] init OSS by config: endpoint={}, bucketName={}, accessKey={}, secretKey={}", new Object[]{endpoint, bucketName, accessKey, secretKey});
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw new IllegalArgumentException("'oms.storage.dfs.minio.bucketName' can't be empty, please creat a bucket in minio oss console then config it to powerjob");
        }
        this.bucket = bucketName;
        this.minioClient = MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build();
        this.createBucket(bucketName);
        log.info("[Minio] initialize OSS successfully!");
    }

    public void createBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
        String policy = "{\n    \"Version\": \"2012-10-17\",\n    \"Statement\": [\n        {\n            \"Action\": [\n                \"s3:GetObject\"\n            ],\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"*\"\n                ]\n            },\n            \"Resource\": [\n                \"arn:aws:s3:::" + bucketName + "/*\"\n            ]\n        }\n    ]\n}";
        this.minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(policy).build());
    }

    public boolean bucketExists(String bucketName) {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    public static class MinioOssCondition
    extends PropertyAndOneBeanCondition {
        protected List<String> anyConfigKey() {
            return Lists.newArrayList((Object[])new String[]{"oms.storage.dfs.minio.endpoint"});
        }

        protected Class<?> beanType() {
            return DFsService.class;
        }
    }
}

