/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.server.redirector;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.remote.framework.base.URL;
import tech.powerjob.server.persistence.remote.model.AppInfoDO;
import tech.powerjob.server.persistence.remote.repository.AppInfoRepository;
import tech.powerjob.server.remote.server.redirector.DesignateServer;
import tech.powerjob.server.remote.server.redirector.RemoteProcessReq;
import tech.powerjob.server.remote.transporter.TransportService;
import tech.powerjob.server.remote.transporter.impl.ServerURLFactory;

@Aspect
@Component
@Order(value=0)
public class DesignateServerAspect {
    private static final Logger log = LoggerFactory.getLogger(DesignateServerAspect.class);
    private final TransportService transportService;
    private final AppInfoRepository appInfoRepository;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Around(value="@annotation(designateServer))")
    public Object execute(ProceedingJoinPoint point, DesignateServer designateServer) throws Throwable {
        Object[] args = point.getArgs();
        String methodName = point.getSignature().getName();
        String className = point.getSignature().getDeclaringTypeName();
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        String[] parameterNames = methodSignature.getParameterNames();
        String[] parameterTypes = (String[])Arrays.stream(methodSignature.getParameterTypes()).map(Class::getName).toArray(String[]::new);
        Long appId = null;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!StringUtils.equals((CharSequence)parameterNames[i], (CharSequence)designateServer.appIdParameterName())) continue;
            appId = Long.parseLong(String.valueOf(args[i]));
            break;
        }
        if (appId == null) {
            throw new PowerJobException("can't find appId in params for:" + signature);
        }
        AppInfoDO appInfo = (AppInfoDO)this.appInfoRepository.findById(appId).orElseThrow(() -> new PowerJobException("can't find app info"));
        String targetServer = appInfo.getCurrentServer();
        if (StringUtils.isEmpty((CharSequence)targetServer)) {
            return point.proceed();
        }
        if (Objects.equals(targetServer, this.transportService.defaultProtocol().getAddress())) {
            return point.proceed();
        }
        log.info("[DesignateServerAspect] the method[{}] should execute in server[{}], so this request will be redirect to remote server!", (Object)signature.toShortString(), (Object)targetServer);
        RemoteProcessReq remoteProcessReq = new RemoteProcessReq().setClassName(className).setMethodName(methodName).setParameterTypes(parameterTypes).setArgs(args);
        URL friendUrl = ServerURLFactory.process2Friend(targetServer);
        CompletionStage<AskResponse> askCS = this.transportService.ask(Protocol.HTTP.name(), friendUrl, remoteProcessReq, AskResponse.class);
        AskResponse askResponse = askCS.toCompletableFuture().get(5000L, TimeUnit.MILLISECONDS);
        if (!askResponse.isSuccess()) {
            throw new PowerJobException("remote process failed: " + askResponse.getMessage());
        }
        Method method = methodSignature.getMethod();
        JavaType returnType = DesignateServerAspect.getMethodReturnJavaType(method);
        return OBJECT_MAPPER.readValue(askResponse.getData(), returnType);
    }

    private static JavaType getMethodReturnJavaType(Method method) {
        Type type = method.getGenericReturnType();
        return DesignateServerAspect.getJavaType(type);
    }

    private static JavaType getJavaType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Class rowClass = (Class)((ParameterizedType)type).getRawType();
            JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                javaTypes[i] = DesignateServerAspect.getJavaType(actualTypeArguments[i]);
            }
            return TypeFactory.defaultInstance().constructParametricType(rowClass, javaTypes);
        }
        return TypeFactory.defaultInstance().constructParametricType((Class)type, new JavaType[0]);
    }

    public DesignateServerAspect(TransportService transportService, AppInfoRepository appInfoRepository) {
        this.transportService = transportService;
        this.appInfoRepository = appInfoRepository;
    }
}

