/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.remote.transporter;

import tech.powerjob.common.utils.PropertyUtils;
import tech.powerjob.remote.framework.base.Address;
import tech.powerjob.remote.framework.transporter.Transporter;

public class ProtocolInfo {
    private String protocol;
    private String address;
    private String externalAddress;
    private transient Transporter transporter;

    public ProtocolInfo() {
    }

    public ProtocolInfo(String protocol, String host, int port, Transporter transporter) {
        this.protocol = protocol;
        this.transporter = transporter;
        this.address = Address.toFullAddress((String)host, (int)port);
        String externalAddress = PropertyUtils.readProperty((String)"powerjob.network.external.address", (String)host);
        String externalPortByProtocolKey = "powerjob.network.external.port".concat(".").concat(protocol.toLowerCase());
        String externalPort = PropertyUtils.readProperty((String)externalPortByProtocolKey, (String)PropertyUtils.readProperty((String)"powerjob.network.external.port", (String)String.valueOf(port)));
        this.externalAddress = Address.toFullAddress((String)externalAddress, (int)Integer.parseInt(externalPort));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public Transporter getTransporter() {
        return this.transporter;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public void setTransporter(Transporter transporter) {
        this.transporter = transporter;
    }

    public String toString() {
        return "ProtocolInfo(protocol=" + this.getProtocol() + ", address=" + this.getAddress() + ", externalAddress=" + this.getExternalAddress() + ", transporter=" + this.getTransporter() + ")";
    }
}

