/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.controller;

import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.powerjob.common.PowerQuery;
import tech.powerjob.common.enums.InstanceStatus;
import tech.powerjob.common.request.http.SaveJobInfoRequest;
import tech.powerjob.common.request.http.SaveWorkflowNodeRequest;
import tech.powerjob.common.request.http.SaveWorkflowRequest;
import tech.powerjob.common.request.query.JobInfoQuery;
import tech.powerjob.common.response.InstanceInfoDTO;
import tech.powerjob.common.response.JobInfoDTO;
import tech.powerjob.common.response.ResultDTO;
import tech.powerjob.common.response.WorkflowInstanceInfoDTO;
import tech.powerjob.server.core.instance.InstanceService;
import tech.powerjob.server.core.service.AppInfoService;
import tech.powerjob.server.core.service.CacheService;
import tech.powerjob.server.core.service.JobService;
import tech.powerjob.server.core.workflow.WorkflowInstanceService;
import tech.powerjob.server.core.workflow.WorkflowService;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.web.response.WorkflowInfoVO;

@RestController
@RequestMapping(value={"/openApi"})
public class OpenAPIController {
    private final AppInfoService appInfoService;
    private final JobService jobService;
    private final InstanceService instanceService;
    private final WorkflowService workflowService;
    private final WorkflowInstanceService workflowInstanceService;
    private final CacheService cacheService;

    @PostMapping(value={"/assert"})
    public ResultDTO<Long> assertAppName(String appName, @RequestParam(required=false) String password) {
        return ResultDTO.success((Object)this.appInfoService.assertApp(appName, password));
    }

    @PostMapping(value={"/saveJob"})
    public ResultDTO<Long> saveJob(@RequestBody SaveJobInfoRequest request) {
        if (request.getId() != null) {
            this.checkJobIdValid(request.getId(), request.getAppId());
        }
        return ResultDTO.success((Object)this.jobService.saveJob(request));
    }

    @PostMapping(value={"/copyJob"})
    public ResultDTO<Long> copyJob(Long jobId) {
        return ResultDTO.success((Object)this.jobService.copyJob(jobId).getId());
    }

    @PostMapping(value={"/exportJob"})
    public ResultDTO<SaveJobInfoRequest> exportJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        return ResultDTO.success((Object)this.jobService.exportJob(jobId));
    }

    @PostMapping(value={"/fetchJob"})
    public ResultDTO<JobInfoDTO> fetchJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        return ResultDTO.success((Object)this.jobService.fetchJob(jobId));
    }

    @PostMapping(value={"/fetchAllJob"})
    public ResultDTO<List<JobInfoDTO>> fetchAllJob(Long appId) {
        return ResultDTO.success((Object)this.jobService.fetchAllJob(appId));
    }

    @PostMapping(value={"/queryJob"})
    public ResultDTO<List<JobInfoDTO>> queryJob(@RequestBody JobInfoQuery powerQuery) {
        return ResultDTO.success((Object)this.jobService.queryJob((PowerQuery)powerQuery));
    }

    @PostMapping(value={"/deleteJob"})
    public ResultDTO<Void> deleteJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        this.jobService.deleteJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/disableJob"})
    public ResultDTO<Void> disableJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        this.jobService.disableJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/enableJob"})
    public ResultDTO<Void> enableJob(Long jobId, Long appId) {
        this.checkJobIdValid(jobId, appId);
        this.jobService.enableJob(jobId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/runJob"})
    public ResultDTO<Long> runJob(Long appId, Long jobId, @RequestParam(required=false) String instanceParams, @RequestParam(required=false) Long delay) {
        this.checkJobIdValid(jobId, appId);
        return ResultDTO.success((Object)this.jobService.runJob(appId, jobId, instanceParams, delay));
    }

    @PostMapping(value={"/stopInstance"})
    public ResultDTO<Void> stopInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.stopInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/cancelInstance"})
    public ResultDTO<Void> cancelInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.cancelInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/retryInstance"})
    public ResultDTO<Void> retryInstance(Long instanceId, Long appId) {
        this.checkInstanceIdValid(instanceId, appId);
        this.instanceService.retryInstance(appId, instanceId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/fetchInstanceStatus"})
    public ResultDTO<Integer> fetchInstanceStatus(Long instanceId) {
        InstanceStatus instanceStatus = this.instanceService.getInstanceStatus(instanceId);
        return ResultDTO.success((Object)instanceStatus.getV());
    }

    @PostMapping(value={"/fetchInstanceInfo"})
    public ResultDTO<InstanceInfoDTO> fetchInstanceInfo(Long instanceId) {
        return ResultDTO.success((Object)this.instanceService.getInstanceInfo(instanceId));
    }

    @PostMapping(value={"/queryInstance"})
    public ResultDTO<List<InstanceInfoDTO>> queryInstance(@RequestBody PowerQuery powerQuery) {
        return ResultDTO.success((Object)this.instanceService.queryInstanceInfo(powerQuery));
    }

    @PostMapping(value={"/saveWorkflow"})
    public ResultDTO<Long> saveWorkflow(@RequestBody SaveWorkflowRequest request) {
        return ResultDTO.success((Object)this.workflowService.saveWorkflow(request));
    }

    @PostMapping(value={"/copyWorkflow"})
    public ResultDTO<Long> copy(Long workflowId, Long appId) {
        return ResultDTO.success((Object)this.workflowService.copyWorkflow(workflowId, appId));
    }

    @PostMapping(value={"/fetchWorkflow"})
    public ResultDTO<WorkflowInfoVO> fetchWorkflow(Long workflowId, Long appId) {
        WorkflowInfoDO workflowInfoDO = this.workflowService.fetchWorkflow(workflowId, appId);
        return ResultDTO.success((Object)WorkflowInfoVO.from(workflowInfoDO));
    }

    @PostMapping(value={"/deleteWorkflow"})
    public ResultDTO<Void> deleteWorkflow(Long workflowId, Long appId) {
        this.workflowService.deleteWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/disableWorkflow"})
    public ResultDTO<Void> disableWorkflow(Long workflowId, Long appId) {
        this.workflowService.disableWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/enableWorkflow"})
    public ResultDTO<Void> enableWorkflow(Long workflowId, Long appId) {
        this.workflowService.enableWorkflow(workflowId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/runWorkflow"})
    public ResultDTO<Long> runWorkflow(Long workflowId, Long appId, @RequestParam(required=false) String initParams, @RequestParam(required=false) Long delay) {
        return ResultDTO.success((Object)this.workflowService.runWorkflow(workflowId, appId, initParams, delay));
    }

    @PostMapping(value={"/addWorkflowNode"})
    public ResultDTO<List<WorkflowNodeInfoDO>> saveWorkflowNode(@RequestBody List<SaveWorkflowNodeRequest> request) {
        return ResultDTO.success((Object)this.workflowService.saveWorkflowNode(request));
    }

    @PostMapping(value={"/stopWfInstance"})
    public ResultDTO<Void> stopWorkflowInstance(Long wfInstanceId, Long appId) {
        this.workflowInstanceService.stopWorkflowInstanceEntrance(wfInstanceId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/retryWfInstance"})
    public ResultDTO<Void> retryWorkflowInstance(Long wfInstanceId, Long appId) {
        this.workflowInstanceService.retryWorkflowInstance(wfInstanceId, appId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/markWorkflowNodeAsSuccess"})
    public ResultDTO<Void> markWorkflowNodeAsSuccess(Long wfInstanceId, Long nodeId, Long appId) {
        this.workflowInstanceService.markNodeAsSuccess(appId, wfInstanceId, nodeId);
        return ResultDTO.success(null);
    }

    @PostMapping(value={"/fetchWfInstanceInfo"})
    public ResultDTO<WorkflowInstanceInfoDTO> fetchWorkflowInstanceInfo(Long wfInstanceId, Long appId) {
        return ResultDTO.success((Object)this.workflowInstanceService.fetchWorkflowInstanceInfo(wfInstanceId, appId));
    }

    private void checkInstanceIdValid(Long instanceId, Long appId) {
        Long realAppId = this.cacheService.getAppIdByInstanceId(instanceId);
        if (realAppId == null) {
            throw new IllegalArgumentException("can't find instance by instanceId: " + instanceId);
        }
        if (appId.equals(realAppId)) {
            return;
        }
        throw new IllegalArgumentException("instance is not belong to the app whose appId is " + appId);
    }

    private void checkJobIdValid(Long jobId, Long appId) {
        Long realAppId = this.cacheService.getAppIdByJobId(jobId);
        if (realAppId == null) {
            throw new IllegalArgumentException("can't find job by jobId: " + jobId);
        }
        if (!appId.equals(realAppId)) {
            throw new IllegalArgumentException("this job is not belong to the app whose appId is " + appId);
        }
    }

    public OpenAPIController(AppInfoService appInfoService, JobService jobService, InstanceService instanceService, WorkflowService workflowService, WorkflowInstanceService workflowInstanceService, CacheService cacheService) {
        this.appInfoService = appInfoService;
        this.jobService = jobService;
        this.instanceService = instanceService;
        this.workflowService = workflowService;
        this.workflowInstanceService = workflowInstanceService;
        this.cacheService = cacheService;
    }
}

