/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.web.websocket;

import java.io.IOException;
import javax.annotation.Resource;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.server.config.OmsEndpointConfigure;
import tech.powerjob.server.core.container.ContainerService;

@Component
@ServerEndpoint(value="/container/deploy/{id}", configurator=OmsEndpointConfigure.class)
public class ContainerDeployServerEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ContainerDeployServerEndpoint.class);
    @Resource
    private ContainerService containerService;

    @OnOpen
    public void onOpen(@PathParam(value="id") Long id, Session session) {
        RemoteEndpoint.Async remote = session.getAsyncRemote();
        remote.sendText("SYSTEM: connected successfully, start to deploy container: " + id);
        try {
            this.containerService.deploy(id, session);
        }
        catch (Exception e) {
            log.error("[ContainerDeployServerEndpoint] deploy container {} failed.", (Object)id, (Object)e);
            remote.sendText("SYSTEM: deploy failed because of the exception");
            remote.sendText(ExceptionUtils.getStackTrace((Throwable)e));
        }
        try {
            session.close();
        }
        catch (Exception e) {
            log.error("[ContainerDeployServerEndpoint] close session for {} failed.", (Object)id, (Object)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        try {
            session.close();
        }
        catch (IOException e) {
            log.error("[ContainerDeployServerEndpoint] close session failed.", (Throwable)e);
        }
        log.warn("[ContainerDeployServerEndpoint] session onError!", throwable);
    }
}

