/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerjob.common.model.DeployedContainerInfo;
import tech.powerjob.common.request.ServerDeployContainerRequest;
import tech.powerjob.common.request.WorkerNeedDeployContainerRequest;
import tech.powerjob.common.response.AskResponse;
import tech.powerjob.common.utils.CommonUtils;
import tech.powerjob.worker.common.WorkerRuntime;
import tech.powerjob.worker.common.utils.PowerFileUtils;
import tech.powerjob.worker.common.utils.TransportUtils;
import tech.powerjob.worker.container.OmsContainer;
import tech.powerjob.worker.container.OmsJarContainer;

public class OmsContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(OmsContainerFactory.class);
    private static final String CONTAINER_DIR = PowerFileUtils.workspace() + "/container/";
    private static final Map<Long, OmsContainer> CARGO = Maps.newConcurrentMap();

    public static OmsContainer fetchContainer(Long containerId, WorkerRuntime workerRuntime) {
        OmsContainer omsContainer = CARGO.get(containerId);
        if (omsContainer != null) {
            return omsContainer;
        }
        String currentServerAddress = workerRuntime.getServerDiscoveryService().getCurrentServerAddress();
        log.info("[OmsContainer-{}] can't find the container in factory, try to deploy from server.", (Object)containerId);
        WorkerNeedDeployContainerRequest request = new WorkerNeedDeployContainerRequest(containerId);
        try {
            AskResponse askResponse = TransportUtils.reliableQueryContainerInfo(request, currentServerAddress, workerRuntime.getTransporter());
            if (askResponse.isSuccess()) {
                ServerDeployContainerRequest deployRequest = (ServerDeployContainerRequest)askResponse.getData(ServerDeployContainerRequest.class);
                log.info("[OmsContainer-{}] fetch containerInfo from server successfully.", (Object)containerId);
                OmsContainerFactory.deployContainer(deployRequest);
            } else {
                log.warn("[OmsContainer-{}] fetch containerInfo failed, reason is {}.", (Object)containerId, (Object)askResponse.getMessage());
            }
        }
        catch (Exception e) {
            log.error("[OmsContainer-{}] get container failed, exception is {}", (Object)containerId, (Object)e.toString());
        }
        return CARGO.get(containerId);
    }

    public static synchronized void deployContainer(ServerDeployContainerRequest request) {
        Long containerId = request.getContainerId();
        String containerName = request.getContainerName();
        String version = request.getVersion();
        log.info("[OmsContainer-{}] start to deploy container(name={},version={},downloadUrl={})", new Object[]{containerId, containerName, version, request.getDownloadURL()});
        OmsContainer oldContainer = CARGO.get(containerId);
        if (oldContainer != null && version.equals(oldContainer.getVersion())) {
            log.info("[OmsContainer-{}] version={} already deployed, so skip this deploy task.", (Object)containerId, (Object)version);
            return;
        }
        String filePath = CONTAINER_DIR + containerId + "/" + version + ".jar";
        File jarFile = new File(filePath);
        try {
            if (!jarFile.exists()) {
                FileUtils.forceMkdirParent((File)jarFile);
                FileUtils.copyURLToFile((URL)new URL(request.getDownloadURL()), (File)jarFile, (int)5000, (int)300000);
                log.info("[OmsContainer-{}] download jar successfully, path={}", (Object)containerId, (Object)jarFile.getPath());
            }
            OmsJarContainer newContainer = new OmsJarContainer(containerId, containerName, version, jarFile);
            newContainer.init();
            CARGO.put(containerId, newContainer);
            log.info("[OmsContainer-{}] deployed new version:{} successfully!", (Object)containerId, (Object)version);
            if (oldContainer != null) {
                oldContainer.destroy();
            }
        }
        catch (Exception e) {
            log.error("[OmsContainer-{}] deployContainer(name={},version={}) failed.", new Object[]{containerId, containerName, version, e});
            CommonUtils.executeIgnoreException(() -> FileUtils.forceDelete((File)jarFile));
        }
    }

    public static List<DeployedContainerInfo> getDeployedContainerInfos() {
        LinkedList info = Lists.newLinkedList();
        CARGO.forEach((name, container) -> info.add(new DeployedContainerInfo(container.getContainerId(), container.getVersion(), container.getDeployedTime().longValue(), null)));
        return info;
    }

    public static void destroyContainer(Long containerId) {
        OmsContainer container = CARGO.remove(containerId);
        if (container == null) {
            log.info("[OmsContainer-{}] container not exists, so there is no need to destroy the container.", (Object)containerId);
            return;
        }
        try {
            container.destroy();
        }
        catch (Exception e) {
            log.warn("[OmsContainer-{}] destroy container failed.", (Object)containerId, (Object)e);
        }
    }
}

