/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.log.impl;

import tech.powerjob.common.enums.LogLevel;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.worker.background.OmsLogHandler;
import tech.powerjob.worker.log.impl.AbstractOmsLogger;

public class OmsServerLogger
extends AbstractOmsLogger {
    private final long instanceId;
    private final OmsLogHandler omsLogHandler;

    public OmsServerLogger(LogConfig logConfig, long instanceId, OmsLogHandler omsLogHandler) {
        super(logConfig);
        this.instanceId = instanceId;
        this.omsLogHandler = omsLogHandler;
    }

    @Override
    public void debug0(String messagePattern, Object ... args) {
        this.process(LogLevel.DEBUG, messagePattern, args);
    }

    @Override
    public void info0(String messagePattern, Object ... args) {
        this.process(LogLevel.INFO, messagePattern, args);
    }

    @Override
    public void warn0(String messagePattern, Object ... args) {
        this.process(LogLevel.WARN, messagePattern, args);
    }

    @Override
    public void error0(String messagePattern, Object ... args) {
        this.process(LogLevel.ERROR, messagePattern, args);
    }

    private void process(LogLevel level, String messagePattern, Object ... args) {
        String logContent = OmsServerLogger.genLogContent(messagePattern, args);
        this.omsLogHandler.submitLog(this.instanceId, level, logContent);
    }
}

