package tp.score.api.dto.cart;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/28.
 */
public class OrderItemDto implements Serializable {
    /**
     * 产品类型{@value}: 商品
     */
    public static final String PRODUCT_TYPE_MERCHANDISE = "1";
    /**
     * 产品类型{@value}: 配件
     */
    public static final String PRODUCT_TYPE_FITTING = "2";
    /**
     * 产品类型{@value}: 赠品
     */
    public static final String PRODUCT_TYPE_GIFT = "3";

    protected String id;
    private String productId;
    private String goodsId;
    private String productName;    //包括规格
    private String productFashId;

    /**
     * 购买数量
     */
    private Integer count;

    private Integer returnCount;

    /**
     * 商品售价
     */
    private BigDecimal salePrice;

    /**
     * 会员价
     */
    private BigDecimal memberPrice;

    /**
     * 商品成本价
     */
    private BigDecimal costPrice;

    /**
     * 商品最终售价
     */
    private BigDecimal finalPrice;

    /**
     * 秒杀价
     */
    private BigDecimal seckillPrice;

    /**
     * 产品价格
     */
    private BigDecimal productPrice;

    /**
     * 下单时商品销售价格浮动比例
     */
    private BigDecimal salePriceRate;

    private BigDecimal historyCostScore;
    /**
     * 是否已评价
     */
    private Boolean isDiscuss = false;
    //是否是活动商品
    private String activityId;
    /**
     * 是否已退货
     */
    private Boolean isRefund = false;

    /**
     * 预计送达时间（苏宁、）
     */
    private String arriveDate;

    /**
     * 供应商货物编码，如京东、苏宁的skuId
     */
    private String sku;

    /**
     * 第三方订单行号（苏宁、）
     */
    private String orderLineNumId;

    /**
     * 第三方套餐商品编号
     */
    private String packageNumber;

    /**
     * 下单时的第三方售价
     */
    private BigDecimal trdSalePrice;

    /**
     * 产品类型
     */
    private String productType;

    /**
     * 产品图片
     */
    private String productPic;

    /**
     * 从属于当前Item的子Item
     */
    private List<OrderItemDto> children;

    /**
     * 比价商品信息
     */
    private List<OrderParityDto> orderParities;

    private String orderId;

    private String orderNo;

    private String companyId;

    private OrderMainDto order;

    public OrderMainDto getOrder() {
        return order;
    }

    /**
     * 原始商品售价，当存在主、配件组合时，此价格为主商品价格
     */
    private BigDecimal orginSalePrice;

    public void setOrder(OrderMainDto order) {
        this.order = order;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OrderItemDto orderItem = (OrderItemDto) o;

        return !(id != null ? !id.equals(orderItem.id) : orderItem.id != null);

    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }

    public BigDecimal getHistoryCostScore() {
        return historyCostScore;
    }

    public void setHistoryCostScore(BigDecimal historyCostScore) {
        this.historyCostScore = historyCostScore;
    }

    public Boolean getDiscuss() {
        return isDiscuss;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Integer getReturnCount() {
        return returnCount;
    }

    public void setReturnCount(Integer returnCount) {
        this.returnCount = returnCount;
    }

    public String getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(String goodsId) {
        this.goodsId = goodsId;
    }

    public BigDecimal getProductPrice() {
        return productPrice;
    }

    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductFashId() {
        return productFashId;
    }

    public void setProductFashId(String productFashId) {
        this.productFashId = productFashId;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public BigDecimal getMemberPrice() {
        return memberPrice;
    }

    public void setMemberPrice(BigDecimal memberPrice) {
        this.memberPrice = memberPrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public BigDecimal getFinalPrice() {
        return finalPrice;
    }

    public void setFinalPrice(BigDecimal finalPrice) {
        this.finalPrice = finalPrice;
    }

    public BigDecimal getSeckillPrice() {
        return seckillPrice;
    }

    public void setSeckillPrice(BigDecimal seckillPrice) {
        this.seckillPrice = seckillPrice;
    }

    public Boolean isDiscuss() {
        return isDiscuss;
    }

    public void setDiscuss(Boolean discuss) {
        isDiscuss = discuss;
    }

    public Boolean getIsDiscuss() {
        return isDiscuss;
    }

    public void setIsDiscuss(Boolean discuss) {
        isDiscuss = discuss;
    }

    public String getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(String arriveDate) {
        this.arriveDate = arriveDate;
    }

    public String getOrderLineNumId() {
        return orderLineNumId;
    }

    public void setOrderLineNumId(String orderLineNumId) {
        this.orderLineNumId = orderLineNumId;
    }

    public String getPackageNumber() {
        return packageNumber;
    }

    public void setPackageNumber(String packageNumber) {
        this.packageNumber = packageNumber;
    }

    public Boolean getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Boolean refund) {
        isRefund = refund;
    }

    public Boolean getRefund() {
        return isRefund;
    }

    public void setRefund(Boolean refund) {
        isRefund = refund;
    }

    public BigDecimal getSalePriceRate() {
        return salePriceRate;
    }

    public void setSalePriceRate(BigDecimal salePriceRate) {
        this.salePriceRate = salePriceRate;
    }


    /**
     * 获取 下单时的第三方售价
     */
    public BigDecimal getTrdSalePrice() {
        return this.trdSalePrice;
    }

    /**
     * 设置 下单时的第三方售价
     */
    public void setTrdSalePrice(BigDecimal trdSalePrice) {
        this.trdSalePrice = trdSalePrice;
    }


    /**
     * 获取 供应商货物编码，如京东、苏宁的skuId
     */
    public String getSku() {
        return this.sku;
    }

    /**
     * 设置 供应商货物编码，如京东、苏宁的skuId
     */
    public void setSku(String sku) {
        this.sku = sku;
    }

    /**
     * 获取 比价商品信息
     */
    public List<OrderParityDto> getOrderParities() {
        return this.orderParities;
    }

    /**
     * 设置 比价商品信息
     */
    public void setOrderParities(List<OrderParityDto> orderParities) {
        this.orderParities = orderParities;
    }

    public String getProductType() {
        return productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getProductPic() {
        return productPic;
    }

    public void setProductPic(String productPic) {
        this.productPic = productPic;
    }

    public List<OrderItemDto> getChildren() {
        return children;
    }

    public void setChildren(List<OrderItemDto> children) {
        this.children = children;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public BigDecimal getOrginSalePrice() {
        return orginSalePrice;
    }

    public void setOrginSalePrice(BigDecimal orginSalePrice) {
        this.orginSalePrice = orginSalePrice;
    }

    /**
     * 商品价格小计（单价 * 数量）
     * @return
     */
    public BigDecimal getSumSalePrice() {
        if(this.getSalePrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getSalePrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 会员价小计（单价 * 数量）
     */
    public BigDecimal getSumMemberPrice() {
        if(this.getMemberPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getMemberPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 商品成本价小计（单价 * 数量）
     */
    public BigDecimal getSumCostPrice() {
        if(this.getCostPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getCostPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 商品最终售价小计（单价 * 数量）
     */
    public BigDecimal getSumFinalPrice() {
        if(this.getFinalPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getFinalPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 秒杀价小计（单价 * 数量）
     */
    public BigDecimal getSumSeckillPrice() {
        if(this.getSeckillPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getSeckillPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * 产品价格小计（单价 * 数量）
     */
    public BigDecimal getSumProductPrice() {
        if(this.getProductPrice() == null){
            return BigDecimal.ZERO;
        }
        return this.getProductPrice().multiply(BigDecimal.valueOf(this.count == null? 1 :this.count)).setScale(2, BigDecimal.ROUND_HALF_UP);
    }
}
