package tp.score.api.dto.cart;

import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;

/**
 * 订单属性动态扩展表
 * @author Liang Wenxu
 * @since 2017/2/23
 * Created by Liang Wenxu on 2017/2/23.
 */
public class OrderMainAttrDto extends BaseDomainDto implements Serializable{
    public static final String ORDER_ATTR_TYPE_JSON = "JSON"; // 一般JSON串
    public static final String ORDER_ATTR_TYPE_TEXT = "TEXT"; // 纯文本
    public static final String ORDER_ATTR_TYPE_FLOAT = "FLOAT"; // 小数
    public static final String ORDER_ATTR_TYPE_JSON_LIST = "JSON_LIST"; // 转换成JSON的数组/列表
    public static final String JD_EK_FROM_JD="JDEK_FORM_JD";//来自京东的京东E卡库存，非本地
    public static final String JD_EK_KM_CODE="JD_EK_KM_CODE";  //京东E卡卡密code
    public static final String JD_EK_XUNI_GOOD_DATA="JD_EK_XUNI_GOOD_DATA";  //京东E卡data信息
    public static final String JD_EK_PHONE_CODE="JD_EK_PHONE_CODE";  //京东E卡发送手机号
    public static final String JD_EK_XUNI_GOOD="JD_EK_XUNI_GOOD";  //京东E卡产品标识
    public static final String JD_EK_XUNI_GOOD_ORDERAMT="JD_EK_XUNI_GOOD_ORDERAMT";  //支付给福利高的钱

    protected String id;

    private OrderMainDto order;

    /**
     * 属性名
     */
    private String attrName;

    /**
     * 备注（预留字段）
     */
    private String remark;

    /**
     * 属性类型（便于类型转换）
     */
    private String type;

    /**
     * 属性值
     */
    private String attrValue;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderMainDto getOrder() {
        return order;
    }

    public void setOrder(OrderMainDto order) {
        this.order = order;
    }

    public String getAttrName() {
        return attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAttrValue() {
        return attrValue;
    }

    public void setAttrValue(String attrValue) {
        this.attrValue = attrValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof OrderMainAttrDto)) return false;

        OrderMainAttrDto that = (OrderMainAttrDto) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (attrName != null ? !attrName.equals(that.attrName) : that.attrName != null) return false;
        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        return attrValue != null ? attrValue.equals(that.attrValue) : that.attrValue == null;

    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (attrName != null ? attrName.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (attrValue != null ? attrValue.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "OrderMainAttr{" +
                "id='" + id + '\'' +
                ", order=" + order +
                ", attrName='" + attrName + '\'' +
                ", remark='" + remark + '\'' +
                ", type='" + type + '\'' +
                ", attrValue='" + attrValue + '\'' +
                '}';
    }
}
