package tp.score.api.dto.cart;

import com.alibaba.fastjson.annotation.JSONField;
import sinomall.global.dto.base.BaseDomainDto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by xiaoqian on 2016/9/28.
 */
public class SubOrderDto extends BaseDomainDto implements Serializable{

    //对账状态
    public final static String JD_STATUS_SUCCESS = "1";//已确认
    public final static String JD_STATUS_WAIT = "3";//未匹配
    public final static String JD_STATUS_FAIL = "2";//需要处理

    //物流状态
    public final static String TRD_SP_NEW_CREATE = "0";//新建
    public final static String TRD_SP_HAS_BEEN_PUT = "1";//已妥投
    public final static String TRD_SP_REFUSE = "2";//拒收
    public final static String TRD_SP_RETURN = "3";//t退货

    protected String id;

    private OrderMainDto order;

    private List<SubOrderItemDto> subOrderItems;

    private String subOrderNo;

    //供应商对账状态
    private String jdstatus;


    /**
     * 运费
     */
    private BigDecimal freight;

    /**
     * 协议价总价
     */
    private BigDecimal sumCostPrice;

    /**
     * 第三方商户物流状态
     * @since 2017-06-28
     */
    private String trdSpState;

    /**
     * 第三方商户订单状态
     * @since 2017-06-28
     */
    private String trdOrderState;

    /**
     * 第三方商户订单确认下单状态
     * @since 2017-06-28
     */
    private String trdSubmitState;

    /**
     * 供应商对账完成时间
     * 只有对账成功才数据，其他场景都不进行数据写入
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")     private Date confirmBalanceDate;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OrderMainDto getOrder() {
        return this.order;
    }

    public void setOrder(OrderMainDto order) {
        this.order = order;
    }

    public List<SubOrderItemDto> getSubOrderItems() {
        return this.subOrderItems;
    }

    public void setSubOrderItems(List<SubOrderItemDto> subOrderItems) {
        this.subOrderItems = subOrderItems;
    }

    public String getSubOrderNo() {
        return this.subOrderNo;
    }

    public void setSubOrderNo(String subOrderNo) {
        this.subOrderNo = subOrderNo;
    }

    //供应商对账状态
    public String getJdstatus() {
        return this.jdstatus;
    }

    //供应商对账状态
    public void setJdstatus(String jdstatus) {
        this.jdstatus = jdstatus;
    }

    /**
     * 获取 运费
     */
    public BigDecimal getFreight() {
        return this.freight;
    }

    /**
     * 设置 运费
     */
    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    /**
     * 获取 协议价总价
     */
    public BigDecimal getSumCostPrice() {
        return this.sumCostPrice;
    }

    /**
     * 设置 协议价总价
     */
    public void setSumCostPrice(BigDecimal sumCostPrice) {
        this.sumCostPrice = sumCostPrice;
    }

    /**
     * 第三方商户物流状态
     * @since 2017-06-28
     */
    public String getTrdSpState() {
        return this.trdSpState;
    }

    /**
     * 第三方商户物流状态
     * @since 2017-06-28
     */
    public void setTrdSpState(String trdSpState) {
        this.trdSpState = trdSpState;
    }

    /**
     * 第三方商户订单状态
     * @since 2017-06-28
     */
    public String getTrdOrderState() {
        return this.trdOrderState;
    }

    /**
     * 第三方商户订单状态
     * @since 2017-06-28
     */
    public void setTrdOrderState(String trdOrderState) {
        this.trdOrderState = trdOrderState;
    }

    /**
     * 第三方商户订单确认下单状态
     * @since 2017-06-28
     */
    public String getTrdSubmitState() {
        return this.trdSubmitState;
    }

    /**
     * 第三方商户订单确认下单状态
     * @since 2017-06-28
     */
    public void setTrdSubmitState(String trdSubmitState) {
        this.trdSubmitState = trdSubmitState;
    }

    public Date getConfirmBalanceDate() {
        return confirmBalanceDate;
    }

    public void setConfirmBalanceDate(Date confirmBalanceDate) {
        this.confirmBalanceDate = confirmBalanceDate;
    }
}
