/*
 * Decompiled with CFR 0.152.
 */
package tp.score.api.vo;

public class Pager {
    private int totalRows = 0;
    private int pageSize = 5;
    private int currentPage = 1;
    private int totalPages = 1;
    private int startRow = 0;
    private String linkUrl;

    public Pager() {
    }

    public Pager(int _totalRows, int _pageSize) {
        this.totalRows = _totalRows;
        this.pageSize = _pageSize;
        this.totalPages = this.totalRows / this.pageSize;
        int mod = this.totalRows % this.pageSize;
        if (mod > 0) {
            ++this.totalPages;
        }
        this.currentPage = 1;
        this.startRow = 0;
    }

    public Pager(int currentPage, int _totalRows, int _pageSize) {
        int totalPages1 = _totalRows / _pageSize;
        int mod1 = _totalRows % _pageSize;
        this.totalRows = _totalRows;
        this.pageSize = _pageSize;
        if (mod1 > 0) {
            ++totalPages1;
        }
        if (currentPage > totalPages1) {
            --currentPage;
        }
        if (currentPage == 0) {
            this.setStart(1);
        } else {
            this.setStart(currentPage);
        }
        this.totalPages = this.totalRows / this.pageSize;
        int mod = this.totalRows % this.pageSize;
        if (mod > 0) {
            ++this.totalPages;
        } else if (currentPage == 0) {
            currentPage = 1;
        }
    }

    public void setStart(int currentPage) {
        this.currentPage = currentPage;
        this.startRow = (currentPage - 1) * this.pageSize;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        if (this.currentPage == 0) {
            this.currentPage = 1;
        }
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }
}

