package tp.score.service.apiImpl;

import message.model.VerifyCode;
import message.model.repository.RegisterRepos;
import org.springframework.beans.factory.annotation.Autowired;
import tp.score.api.RegisterApi;
import tp.score.api.dto.modeldto.VerifyCodeDto;

import utils.data.BeanMapper;

import java.util.Date;
import java.util.List;

public class RegisterApiImpl implements RegisterApi {

    @Autowired
    RegisterRepos registerRepos;

    @Override
    public void save(VerifyCodeDto verifyCodeDto) {
        VerifyCode verifyCode = BeanMapper.map(verifyCodeDto, VerifyCode.class);
        registerRepos.save(verifyCode);
    }

    @Override
    public List<VerifyCodeDto> findAllByObjIdAndTypeAndDateCreatedAfterOrderByDateCreatedDesc(String objId, String type, Date date) {
        List<VerifyCode> verifyCodeList = registerRepos.findAllByObjIdAndTypeAndDateCreatedAfterOrderByDateCreatedDesc(objId,type,date);
        return BeanMapper.mapList(verifyCodeList,VerifyCode.class,VerifyCodeDto.class);
    }

    @Override
    public List<VerifyCodeDto> findAllByObjIdAndTypeAndSendResultAndDateCreatedAfter(String objId, String type, String sendResult, Date date) {
        List<VerifyCode> verifyCodeList = registerRepos.findAllByObjIdAndTypeAndSendResultAndDateCreatedAfter(objId,type,sendResult,date);
        return BeanMapper.mapList(verifyCodeList,VerifyCode.class,VerifyCodeDto.class);
    }
}
