package tp.score.service.apiImpl.myScore;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderItemDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsDto;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import outsideapi.utils.FlgAseUtil;
import sysmg.api.SystemConfigApi;
import sysmg.dto.SystemConfigDto;
import sysmg.response.SystemConfigValueDto;
import tp.score.api.JdECardConsume;
import tp.score.model.JdCard;
import tp.score.model.repository.JdCardRepo;
import utils.Lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by oracle on 2017-06-12.
 */
@MotanService
public class JdECardConsumeImpl implements JdECardConsume {
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    JdCardRepo jdCardRepo;
    @Autowired
    MapperFacade mapperFacade;

    @Value("${flgVariables.flgAseKey}")
    private String KMKey;

    Logger log = LoggerFactory.getLogger(getClass());

    @MotanReferer
    SystemConfigApi systemConfigApi;

    @Override
    public Map<String, Object> consume(List<tp.score.api.dto.cart.OrderItemDto> orderItemsParam) {
        List<OrderItemDto> orderItems = Lang.isEmpty(orderItemsParam) ? new ArrayList<OrderItemDto>() : mapperFacade.mapAsList(orderItemsParam, OrderItemDto.class);
        StringBuilder jdECardCode = new StringBuilder();
        List<Map<String,String>> list=new ArrayList<>();
        Map<String, Object> resultMap = new HashMap<>();
        String isJdekForMoney=systemConfigApi.getConfigValue("tpScore", SystemConfigDto.CONFIG_CODE_JDEK_FOR_MONEY, SystemConfigValueDto.CONFIG_VALUE_TYPE_JDEK_FOR_MONEY,true,true);
        if("1".equals(isJdekForMoney)){
        for (OrderItemDto orderItem : orderItems) {
            Integer count = orderItem.getCount();
            Map temp=new HashMap<>();
            temp.put("price",orderItem.getCostPrice());
            temp.put("extraCount",count);
            list.add(temp);
        }
        resultMap.put("isExtra","true");
        resultMap.put("extra",list);
        resultMap.put("resCode", "0000");
        resultMap.put("resMessage", "成功");
        }else{
            resultMap.put("jdECardCode", "1111111");
            resultMap.put("resCode", "0000");
            resultMap.put("resMessage", "成功");
        }
        return resultMap;
    }
}
