package tp.score.service.utils.httpPost;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tp.score.api.entity.SendMsgVo;


import org.springframework.transaction.annotation.Transactional;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created by huang on 14-3-31.
 */
@Service("HttpTransmissionService")
@Transactional
public class HttpTransmissionServiceImpl implements HttpTransmissionService {
    static final Logger logger = LoggerFactory.getLogger(HttpTransmissionServiceImpl.class);



    public String sentXmlMethod(String url, String sendStr){
        logger.info("请求数据：{}",sendStr);
        HttpURLConnection connection = null;
        Long startTime = System.currentTimeMillis();
        try {
            URL sentUrl = new URL(url);
            connection = (HttpURLConnection) sentUrl.openConnection();
            connection.setConnectTimeout(10000);// 10s内连不上就断开
            connection.setReadTimeout(180000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");

            // post方式不能使用缓存
            connection.setUseCaches(false);
            connection.setRequestProperty("Charset", "UTF-8");
            // 配置本次连接的Content-Type，配置为text/xml
            connection.setRequestProperty("Content-Type", "text/xml");
            // 维持长连接
            connection.setRequestProperty("Connection", "Keep-Alive");

            connection.setAllowUserInteraction(true);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);

            //String sendXMLGBK = new String(sendXML.getBytes("GBK"),"UTF-8");
            writer.write(sendStr.toString());
            writer.flush();
            writer.close();

            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String strMessage = "";
            StringBuffer buffer = new StringBuffer();
            while ((strMessage = reader.readLine()) != null) {
                buffer.append(strMessage);
            }

            String responseStr = buffer.toString();
            logger.info("请求返回数据：{}", responseStr);
            if (StringUtils.isBlank(responseStr)) {
                throw new RuntimeException("保险公司接口返回结果为空");
            }
            reader.close();
            return responseStr;
        }catch (Exception e){
            e.printStackTrace();
            logger.info("======================================e.message"+e.getMessage()) ;
            return "";
        }finally{
            logger.info("向服务器:{},请求总用时:{} ms",url,(System.currentTimeMillis()-startTime)) ;
            try{
                connection.disconnect();
            }catch (Exception e){
                logger.error("关闭链接时出错:",e);
            }
        }
    }


    @Value("${send.requestUrl}")
    String requestUrl;
    public String sentJsonMethod_del(SendMsgVo sendMsgVo){

        //生成发送报文
        String sendStr = JSON.toJSONString(sendMsgVo, SerializerFeature.UseISO8601DateFormat, SerializerFeature.DisableCircularReferenceDetect);

        logger.info("请求数据：{}",sendStr);
        HttpURLConnection connection = null;
        Long startTime = System.currentTimeMillis();
        try {
            //生成请求url
            URL sentUrl = new URL(requestUrl);
            connection = (HttpURLConnection)sentUrl.openConnection();
            connection.setConnectTimeout(10000);// 10s内连不上就断开
            connection.setReadTimeout(180000);
//            connection.setReadTimeout(20000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");

            // post方式不能使用缓存
            connection.setUseCaches(false);
            connection.setRequestProperty("Charset","UTF-8");
            System.out.print("输出策略安全=============================");
            // 配置本次连接的Content-Type，配置为text/xml
            connection.setRequestProperty("Content-Type","text/json");
            // 维持长连接
            connection.setRequestProperty("Connection","Keep-Alive");
            connection.setAllowUserInteraction(true);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);

            //String sendXMLGBK = new String(sendXML.getBytes("GBK"),"UTF-8");
            writer.write(sendStr.toString());
            writer.flush();
            writer.close();

            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream,"UTF-8"));
            String strMessage = "";
            StringBuffer buffer = new StringBuffer();
            while(( strMessage = reader.readLine() )!=null){
                buffer.append(strMessage);
            }

            String responseStr=buffer.toString();
            logger.info("请求返回数据：{}",responseStr);
            if(StringUtils.isBlank(responseStr)){
                throw new RuntimeException("保险公司接口返回结果为空");
            }
            reader.close();
            return responseStr;
        }catch (Exception e){
            e.printStackTrace();
            return "";
        }finally{
            logger.info("向服务器:{},请求总用时:{} ms",requestUrl,(System.currentTimeMillis()-startTime)) ;
            try{
                connection.disconnect();
            }catch (Exception e){
                logger.error("关闭链接时出错:",e);
            }
        }

    }


}
