/*
 * Decompiled with CFR 0.152.
 */
package tp.score.service.utils.httpPost;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tp.score.api.entity.SendMsgVo;
import tp.score.service.utils.httpPost.HttpTransmissionService;

@Service(value="HttpTransmissionService")
@Transactional
public class HttpTransmissionServiceImpl
implements HttpTransmissionService {
    static final Logger logger = LoggerFactory.getLogger(HttpTransmissionServiceImpl.class);
    @Value(value="${send.requestUrl}")
    String requestUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentXmlMethod(String url, String sendStr) {
        logger.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)sendStr);
        HttpURLConnection connection = null;
        Long startTime = System.currentTimeMillis();
        try {
            URL sentUrl = new URL(url);
            connection = (HttpURLConnection)sentUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(180000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Charset", "UTF-8");
            connection.setRequestProperty("Content-Type", "text/xml");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setAllowUserInteraction(true);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            writer.write(sendStr.toString());
            writer.flush();
            writer.close();
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String strMessage = "";
            StringBuffer buffer = new StringBuffer();
            while ((strMessage = reader.readLine()) != null) {
                buffer.append(strMessage);
            }
            String responseStr = buffer.toString();
            logger.info("\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)responseStr);
            if (StringUtils.isBlank((String)responseStr)) {
                throw new RuntimeException("\u4fdd\u9669\u516c\u53f8\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            reader.close();
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("======================================e.message" + e.getMessage());
            String string = "";
            return string;
        }
        finally {
            logger.info("\u5411\u670d\u52a1\u5668:{},\u8bf7\u6c42\u603b\u7528\u65f6:{} ms", (Object)url, (Object)(System.currentTimeMillis() - startTime));
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u94fe\u63a5\u65f6\u51fa\u9519:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentJsonMethod_del(SendMsgVo sendMsgVo) {
        String sendStr = JSON.toJSONString((Object)sendMsgVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseISO8601DateFormat, SerializerFeature.DisableCircularReferenceDetect});
        logger.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)sendStr);
        HttpURLConnection connection = null;
        Long startTime = System.currentTimeMillis();
        try {
            URL sentUrl = new URL(this.requestUrl);
            connection = (HttpURLConnection)sentUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(180000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Charset", "UTF-8");
            System.out.print("\u8f93\u51fa\u7b56\u7565\u5b89\u5168=============================");
            connection.setRequestProperty("Content-Type", "text/json");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setAllowUserInteraction(true);
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            writer.write(sendStr.toString());
            writer.flush();
            writer.close();
            InputStream inputStream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String strMessage = "";
            StringBuffer buffer = new StringBuffer();
            while ((strMessage = reader.readLine()) != null) {
                buffer.append(strMessage);
            }
            String responseStr = buffer.toString();
            logger.info("\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)responseStr);
            if (StringUtils.isBlank((String)responseStr)) {
                throw new RuntimeException("\u4fdd\u9669\u516c\u53f8\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            reader.close();
            String string = responseStr;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            logger.info("\u5411\u670d\u52a1\u5668:{},\u8bf7\u6c42\u603b\u7528\u65f6:{} ms", (Object)this.requestUrl, (Object)(System.currentTimeMillis() - startTime));
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u94fe\u63a5\u65f6\u51fa\u9519:", (Throwable)e);
            }
        }
    }
}

